<?php

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
    
    /**
     * Plugin that offers features to returns the top read posts object of current blog
     */
    class PluginTopReadPosts extends PluginBase
    {

        var $prefix;
        var $pluginEnabled;
        var $maxPosts;  
    
        function PluginTopReadPosts($source="")
        {
            $this->PluginBase($source);
  
            $this->id = "topreadposts";
            $this->author = "Mark Wu";
            $this->desc = "This plugin offers the rank list of articles by ".
                "number of times read.";  
            $this->version = "20070710";

            $this->prefix = Db::getPrefix();
            
            $this->locales = Array( "en_UK" , "zh_TW" , "zh_CN" );
            if($source == "admin")
                $this->initAdmin(); 
        }

		function initAdmin()
		{
            $this->registerAdminAction( "topreadposts", "PluginTopReadPostsConfigAction" );
			$this->registerAdminAction( "updateTopReadPostsConfig", "PluginTopReadPostsUpdateConfigAction" );
			
			$menu =& Menu::getMenu();
			if( !$menu->entryExists( "/menu/controlCenter/manageTopPlugins" ))						
				$this->addMenuEntry( "/menu/controlCenter", "manageTopPlugins", "", "", true, false );			
            $this->addMenuEntry( "/menu/controlCenter/manageTopPlugins", "TopReadPosts", "?op=topreadposts", "" );            
		}

		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
		    $this->pluginEnabled = $blogSettings->getValue( "plugin_topreadposts_enabled" );
	        $this->maxPosts = $blogSettings->getValue( "plugin_topreadposts_maxposts" );
	    }
	    
	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }
 
        /**
         * Returns the top read posts object of current blog
         */
        function getTopReadPosts($maxPosts = 0, $based = 'BLOG')
        {
            lt_include( PLOG_CLASS_PATH."class/dao/articles.class.php" );
            $articles = new Articles();
            $blogId = $this->blogInfo->getId();
            
            if ($based == 'BLOG') { 
                $query = "SELECT * FROM ".$this->prefix."articles";
                $query .= " WHERE blog_id = ".$blogId." AND status = 1";
                $query .= " ORDER BY num_reads DESC";                
            } elseif ($based == 'SITE') {
                $query = "SELECT * FROM ".$this->prefix."articles";
                $query .= " WHERE status = 1";
                $query .= " ORDER BY num_reads DESC";
            } else {
                return false;
            }

            if( $maxPosts > 0 ) 
            {
                $query .= " LIMIT " . $maxPosts; 
            } else {
                $query .= " LIMIT " . $this->maxPosts;
            }

            $db =& Db::getDb();
            $result = $db->Execute( $query ); 

            if( !$result ) 
                return false; 
            
            $topreadposts = Array();
            while( $row = $result->FetchRow()) { 
               $article = $articles->mapRow( $row );
               array_push( $topreadposts, $article); 
            } 

            return $topreadposts; 
        }

		function getPluginConfigurationKeys()
		{
			lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
			
			return( Array(
				Array( "name" => "plugin_topreadposts_enabled", "type" => "boolean" ),
				Array( "name" => "plugin_topreadposts_maxposts",
                       "validator" => new IntegerValidator(),
                       "type" => "integer", "allowEmpty" => true )
			));
		}
    }
?>