<?php

    lt_include(PLOG_CLASS_PATH . "class/object/object.class.php");

    /**
    * Tidy class.
    */
    class Tidy extends Object
    {
        var $_parsed;
        
        /**
        * Constructor.
        * By default sessions are stored in php files
        */
        function Tidy()
        {
            $this->Object();
            $this->_parsed = false;
        }

        /**
        * Add function info here
        */
        function isInstalled()
        {
            return function_exists("tidy_parse_string");
        }
        
        /**
        * Add function info here
        */
        function isParsed()
        {
            return $this->_parsed;
        }
        
        /**
        * Add function info here
        */
        function setOption($name, $value)
        {
            tidy_setopt($name, $value);
        }

        /**
        * Add function info here
        */
        function setOptions($options)
        {
            if (is_array($options) && count($options) > 0)
            {
                foreach ($options as $key => $value)
                {
                    $this->setOption($key, $value);
                }
            }
        }
        
        /**
        * Add function info here
        */
        function getOption($name)
        {
            tidy_getopt($name);
        }

        /**
        * Add function info here
        */
        function parse($str)
        {
            $this->_parsed = true;
            return tidy_parse_string($str);
        }

        /**
        * Add function info here
        */
        function cleanRepair()
        {
            if (!$this->isParsed())
            {
                throw(new qException("Tidy::cleanRepair: before execute this method, you must parse the string"));
                die();
            }

            return tidy_clean_repair();
        }
        
        /**
        * Add function info here
        */
        function getErrors()
        {
            return tidy_get_error_buffer();
        }

        /**
        * Add function info here
        */
        function getErrorsCount()
        {
            return tidy_error_count();
        }

        /**
        * Add function info here
        */
        function getWarningsCount()
        {
            return tidy_warning_count();
        }

        /**
        * Add function info here
        */
        function getOutput()
        {
            return tidy_get_output();
        }
    }
?>