<?php

	lt_include(PLOG_CLASS_PATH . "class/action/admin/adminaction.class.php");
	lt_include(PLOG_CLASS_PATH . "class/view/admin/adminplugintemplatedview.class.php");
	lt_include(PLOG_CLASS_PATH . "plugins/tidyoutput/class/view/plugintidyoutputconfigview.class.php");
		
    /**
    * PluginTidyOutputUpdateConfigAction class
    */
	class PluginTidyOutputUpdateConfigAction extends AdminAction
	{
        /**
        * Constructor
        */      
		function PluginTidyOutputUpdateConfigAction($actionInfo, $request)
		{
			$this->AdminAction($actionInfo, $request);

            $this->requireAdminPermission( "manage_admin_plugins" );            
		}

        /**
        * Add function info
        */        
		function validate()
		{
			return true;
		}

        /**
        * Add function info
        */  
		function perform()
		{
            // update the plugin configurations to config settings
			$config  = & Config::getConfig();

            $enabled = $this->_request->getValue("enabled");
            $enabled = ($enabled == 1);

            $report  = $this->_request->getValue("report");
            $report  = ($report == 1);

            $silent  = $this->_request->getValue("silent");
            $silent  = ($silent == 1);

            $errors  = $this->_request->getValue("errors");
            $errors  = ($errors == 1);
            
            $config->setValue("plugin_tidyoutput_enabled", $enabled);
            $config->setValue("plugin_tidyoutput_report", $report);
            $config->setValue("plugin_tidyoutput_silent_mode", $silent);
            $config->setValue("plugin_tidyoutput_errors", $errors);
            
            if (!$config->save())
            {
                $this->_view = new PluginTidyOutputConfigView($this->_blogInfo);
                $this->_view->setErrorMessage($this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;
            }
            
			// if everything went ok...
            $this->_session->setValue("blogInfo", $this->_blogInfo);
            $this->saveSession();

            lt_include(PLOG_CLASS_PATH . "plugins/tidyoutput/class/tidy/tidy.class.php");
                  
            $this->_view = new PluginTidyOutputConfigView($this->_blogInfo);
            $this->_view->setValue("tidyInstalled", Tidy::isInstalled());
			$this->_view->setSuccessMessage($this->_locale->tr("tidyoutput_settings_saved_ok"));
			$this->setCommonData();
			
            return true;
		}
	}
?>