<?php
	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
    lt_include( PLOG_CLASS_PATH."class/template/templatesets/templatesetstorage.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/templateeditor/class/archive/archive.php" );

    /**
     * Removes global templates from disk.
     */
    class PluginSiteArchiveTemplateSetAction extends AdminAction
    {

    	var $_templateIds;

        function PluginSiteArchiveTemplateSetAction( $actionInfo, $request )
        {
        	$this->AdminAction( $actionInfo, $request );

			$this->requireAdminPermission( "edit_global_templates" );
        }

        function perform()
        {
			// fetch and sanitize parameters
            $this->_templateId = $this->_request->getValue( "templateId" );
			$this->_templateId = str_replace( "/", "", $this->_templateId );
			$this->_templateId = str_replace( "..", "", $this->_templateId );
        	
        	$ts = new TemplateSetStorage();
            $blogId = $this->_blogInfo->getId();
            $baseTemplateFolder = $ts->getBaseTemplateFolder();
            
			$templateArchive = new zip_file($this->_templateId.".zip");
			$templateArchive->set_options(array( 'basedir' => $baseTemplateFolder,
											     'overwrite' => 1,
											     'inmemory' => 1 ));
			$templateArchive->add_files($this->_templateId);
			$templateArchive->create_archive();
			$templateArchive->download_file();
            
            return true;
        }
    }
?>