<?php

lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
lt_include( PLOG_CLASS_PATH."plugins/technoratitagcloud/class/ducksoup/ducksoup.class.php" );	
    
/**
* offers features to insert Technorati Tags and display them in a Cloud.
*/

class PluginTechnoratiTagCloud extends PluginBase {
	var $pluginEnabled;
	var $apikey;
	var $showtags;

	function PluginTechnoratiTagCloud($source = ""){
	$this->PluginBase($source);

	$this->id = "technoratitagcloud";
	$this->author = "Omar Romero";
	$this->desc = "This plugin will download your technorati tags and display them as a tag cloud.";
	$this->version = "20070315";

	$this->locales = Array( "en_UK" );

	if( $source == "admin" )
		$this->initAdmin();
	else
		$this->init();
	}

	function init(){
		// register the events we want
		$this->registerNotification( EVENT_POST_POST_ADD );
		$this->registerNotification( EVENT_POST_POST_UPDATE );
		$this->registerNotification( EVENT_POST_POST_DELETE );    
	}

	function initAdmin(){
		$this->init();
		$this->registerAdminAction( "technoratitagcloud", "PluginTechnoratiTagCloudConfigAction" );
		$this->registerAdminAction( "updatetechnoratitagcloud", "PluginTechnoratiTagCloudUpdateConfigAction" );
		$menu =& Menu::getMenu();
		$this->addMenuEntry( "/menu/controlCenter/manageSettings", "TechnoratiTagCloud", "?op=technoratitagcloud");
	}	

	function register(){
		$blogSettings = $this->blogInfo->getSettings();
		$this->pluginEnabled = $blogSettings->getValue( "plugin_technoratitagcloud_enabled" );
		$this->apikey = $blogSettings->getValue( "plugin_technoratitagcloud_apikey" );
		$this->showtags = $blogSettings->getValue( "plugin_technoratitagcloud_showtags" );
		
		$this->maxsize = $blogSettings->getValue( "plugin_technoratitagcloud_maxsize" );
		$this->minsize = $blogSettings->getValue( "plugin_technoratitagcloud_minsize" );
		$this->maxweight = $blogSettings->getValue( "plugin_technoratitagcloud_maxweight" );
		$this->minweight = $blogSettings->getValue( "plugin_technoratitagcloud_minweight" );

		//TODO: add values for the max and min weight and size

		$config =& Config::getConfig();
		$this->cacheFolder = $config->getValue('temp_folder');
		$this->cacheFolder = $this->cacheFolder.'/technoratitagcloud/'.$this->blogInfo->getId();
		if( !File::exists( $this->cacheFolder ))
			File::createDir( $this->cacheFolder, 0755 );
	}

	function isEnabled(){
		return $this->pluginEnabled;
	}

	function process( $eventType, $params ){
		// make sure we're processing the right event!
		if( $eventType != EVENT_POST_POST_ADD &&
		    $eventType != EVENT_POST_POST_UPDATE &&
		    $eventType != EVENT_POST_POST_DELETE ){
			return true;
		}
		
		// Load all of the settings for this blog
		$this->register();
		
		// make sure that the plugin is enabled
		if(!$this->isEnabled())
			return true;

		// Update the Technorati Tag Cloud
		$this->createTechnoratiTagCloud();

		return true;
	}

	function createTechnoratiTagCloud(){
		$maxSize = $this->maxsize;
		$maxWeight = $this->maxweight;
		$minSize = $this->minsize;
		$minWeight = $this->minweight;

		$rg = $this->blogInfo->getBlogRequestGenerator();
		$url = $rg->getBaseUrl();

		$api = new duckSoup;
		$api->api_key= $this->apikey;
		$api->type = 'blogposttags';
		$api->params = array('url' => $url, 'limit' => $this->showtags);
		$items = $api->get_content();

		if(!isset($items['item']))
			return true;

		foreach ($items['item'] as $item)
			$tagData[$item['tag']] = $item['posts'] ;
		
		arsort($tagData);
		reset($tagData);
		$max = current($tagData);
		$min = end($tagData);

		// Normalize the maximum values
		$max = $max - $min;

		// avoid a divide by zero if all of the words in our group
		// occur exactly the same number of times.
		if($max == 0)
			$max = 1;


		if (sizeof($tagData)) {
			ksort($tagData);
			$tags_string = "";	

			// Create the Cloud
			foreach( $tagData as $k=>$v) {
				$link = urlencode($k);
				$link = str_replace("%2F", "/", $link);
				$disp = htmlspecialchars($k);			

				$value = $v - $min;

				$size = (($value *$maxSize)/$max) + $minSize;
				$weight = (($value *$maxWeight)/$max) + $minWeight;

				if ($size > $maxSize) $size = $maxSize;
				if ($weight > $maxWeight) $weight = $maxWeight;
				$weight = floor($weight / 100) * 100;

				$tags_string .= "<a rel=\"nofollow\" href=\"http://technorati.com/tag/".$link."?from=".$url."\" style=\"font-size: ".$size."em; font-weight: ".$weight."; line-height: 90%\">".$disp."</a>...\n";
			}
		}

		$saveFile = $this->cacheFolder."/tagcloud";  
		$fh = fopen( $saveFile, "w");
		if ($fh){
			fwrite($fh, $tags_string);
			File::chMod($saveFile, 0644);
		}
	}

	function gettechnoratiTagCloud(){
		$saveFile = $this->cacheFolder."/tagcloud";  
		$Cloud = '';
		if(File::isReadable($saveFile)){
			$fh = fopen( $saveFile, "r");
			if ($fh){
				$Cloud = fread($fh, filesize($saveFile));
				fclose($fh);
			}
		}
		return $Cloud;
	}
}
?>
