<?php
	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/technoratitagcloud/class/view/plugintechnoratitagcloudconfigview.class.php" );	
		
	/**
	 * updates the plugin configuration
	 */
	class PluginTechnoratiTagCloudUpdateConfigAction extends AdminAction
	{
		var $_pluginEnabled;
		var $_apikey;
		var $_showtags;
		var $_maxsize;
		var $_minsize;
		var $_maxweight;
		var $_minweight;
		
		
		function PluginTechnoratiTagCloudUpdateConfigAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );
		}
		
		function validate()
		{
            $errorMessages = array();
			$this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
 	                $this->_pluginEnabled = ($this->_pluginEnabled != "" );			
            
			$this->_apikey = $this->_request->getValue( "apikey" );
			if( $this->_pluginEnabled && empty($this->_apikey) ) {
                $errorMessages[] = "technoratitagcloud_error_apikey";
				$isError = true;
			}
			
			$this->_showtags = $this->_request->getValue( "showtags" );
			if( $this->_pluginEnabled && empty($this->_showtags) ) {
				$this->_showtags = "20";
			}

			$this->_maxsize = $this->_request->getValue( "maxsize" );
			if( $this->_pluginEnabled && empty($this->_maxsize) ) {
				$this->_maxsize = "1.5";
			}
			
			$this->_minsize = $this->_request->getValue( "minsize" );
			if( $this->_pluginEnabled && empty($this->_minsize) ) {
				$this->_minsize = "0.65";
			}
			
			$this->_maxweight = $this->_request->getValue( "maxweight" );
			if( $this->_pluginEnabled && empty($this->_maxweight) ) {
				$this->_maxweight = "200";
			}
			
			$this->_minweight = $this->_request->getValue( "minweight" );
			if( $this->_pluginEnabled && empty($this->_minweight) ) {
				$this->_minweight = "100";
			}
			
			if( count($errorMessages) > 0 ) {
                $this->_view = new PluginTechnoratiTagCloudConfigView( $this->_blogInfo );
				$allerror='';
				foreach( $errorMessages as $error ){
					$allerror .= $this->_locale->tr($error).'<br />';
				}
		$this->_view->setErrorMessage( $this->_locale->tr($allerror));
                $this->setCommonData();
                return false;
            }        	                
			
			return true;
		}
		        
		function perform()
		{
            // // update the plugin configurations to blog setting
			$blogSettings = $this->_blogInfo->getSettings();
            $blogSettings->setValue( "plugin_technoratitagcloud_enabled", $this->_pluginEnabled );
            $blogSettings->setValue( "plugin_technoratitagcloud_apikey", $this->_apikey );
            $blogSettings->setValue( "plugin_technoratitagcloud_showtags", $this->_showtags );
			$blogSettings->setValue( "plugin_technoratitagcloud_maxsize", $this->_maxsize );
			$blogSettings->setValue( "plugin_technoratitagcloud_minsize", $this->_minsize );
			$blogSettings->setValue( "plugin_technoratitagcloud_maxweight", $this->_maxweight );
			$blogSettings->setValue( "plugin_technoratitagcloud_minweight", $this->_minweight );
            $this->_blogInfo->setSettings( $blogSettings ); 
		
			// save the blogs settings
			$blogs = new Blogs();
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new PluginTechnoratiTagCloudConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;
            }
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();

			$this->_view = new PluginTechnoratiTagCloudConfigView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("technoratitagcloud_settings_saved_ok"));
			$this->setCommonData();
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());				
			
			//regenerate the cloud
			$plugins = $this->_pm->getPlugins();
			$plugin = $plugins["technoratitagcloud"];
            $plugin->createTechnoratiTagCloud();
            
            return true;		
		}
	}
?>
