<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/technorati/class/view/admintechnoratipluginsettingsview.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/blogs.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/customfields/customfields.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/customfields/customfield.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );

    class AdminTechnoratiPluginUpdateSettingsAction extends AdminAction 
	{
	
		var $_pluginEnabled;
		var $_key;
    	/**
         * Constructor. If nothing else, it also has to call the constructor of the parent
         * class, BlogAction with the same parameters
         */
        function AdminTechnoratiPluginUpdateSettingsAction( $actionInfo, $request )
        {
        	$this->AdminAction( $actionInfo, $request );
        }
		
		function validate()
		{
			$this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
			
			if( $this->_pluginEnabled == "" )
				$this->_pluginEnabled = false;
			else
				$this->_pluginEnabled = true;
				
			// get the parameters from the request
			$this->_key  = $this->_request->getValue( "pluginKey" );
			
			return true;
		}
		
		/**
		 * checks if the fields already exist and if not, creates them
		 *
		 * @private
		 */
		function _createFields()
		{
			$customFields = new CustomFields();
			$blogFields = $customFields->getBlogCustomFields( $this->_blogInfo->getId());
			
			// check if the checkbox fields exists
			if( !array_key_exists( "technoratiTags", $blogFields )) {
				$customTechnoratiTags = new CustomField( "technoratiTags", 
				                                           $this->_locale->tr("technoratiTags_help"),
														   CUSTOM_FIELD_TEXTBOX,
														   $this->_blogInfo->getId(),
														   false,
														   true );
				$customFields->addCustomField( $customTechnoratiTags );			
			}
			return true;
		}
		
		/**
		 * checks if the fields already exist and if so, disables them (sets them to be "hidden")
		 *
		 * @private
		 */
		function _updateFields()
		{
			$customFields = new CustomFields();
			$blogFields = $customFields->getBlogCustomFields( $this->_blogInfo->getId());
			
			// check if the checkbox fields exists
			if( array_key_exists( "technoratiTags", $blogFields )) {
				$customTechnoratiTags = $blogFields["technoratiTags"];
				$customTechnoratiTags->setHidden( false );
				$customFields->updateCustomField( $customTechnoratiTags );
			}
			return true;
		}		

        /**
         * Carries out the specified action
         */
        function perform()
        {
			// save the plugin settings to the db
			$blogSettings = $this->_blogInfo->getSettings();
			$blogSettings->setValue( "plugin_technorati_enabled", $this->_pluginEnabled );
			$blogSettings->setValue( "plugin_technorati_key", $this->_key );
			$this->_blogInfo->setSettings( $blogSettings );
			$blogs = new Blogs();
			
			// update the settings in the db, and make sure that everything went fine
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new AdminTechnoratiPluginSettingsView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false; 				
			}
			
			// check if the fields already exist and if not, create them
			if( $this->_pluginEnabled )
				$this->_createFields();
			else
				$this->_updateFields();
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();
			
			$this->_view = new AdminTechnoratiPluginSettingsView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("technorati_settings_saved_ok"));			
			$this->setCommonData();
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());			
            
            return true;
        }
    }
?>