<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/tagcloud/class/view/plugintagcloudconfigview.class.php" );	
			
	/**
	 * updates the plugin configuration
	 */
	class PluginTagCloudUpdateConfigAction extends AdminAction
	{
		var $_pluginEnabled;
        var $_maxArticles;
        var $_maxKeywords;
        var $_minFont;
        var $_maxFont;
        var $_minWeight;
        var $_maxWeight;
        var $_bannedKeywords;
        var $_minWordLength;
		
		function PluginTagCloudUpdateConfigAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );
		}
		
		function validate()
		{
            $this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
            $this->_pluginEnabled = ($this->_pluginEnabled != "" );	

            $this->_maxArticles = $this->_request->getValue( "articles" );
            
            $this->_maxKeywords = $this->_request->getValue( "keyword" );
            
            $this->_minFont = $this->_request->getValue( "minFont" );

            $this->_maxFont = $this->_request->getValue( "maxFont" );

            $this->_minWeight = $this->_request->getValue( "minWeight" );
            
            $this->_maxWeight = $this->_request->getValue( "maxWeight" );

            $this->_bannedKeywords = $this->_request->getValue( "bannedKeywords" );
            $this->_minWordLength = $this->_request->getValue( "minWordLength" );
            
            return true;
		}
		        
		function perform()
		{
            // update the plugin configurations to blog setting
			$blogSettings = $this->_blogInfo->getSettings();
            $blogSettings->setValue( "plugin_tagcloud_enabled", $this->_pluginEnabled );
            $blogSettings->setValue( "plugin_tagcloud_max_articles", $this->_maxArticles );
            $blogSettings->setValue( "plugin_tagcloud_max_keywords", $this->_maxKeywords );
            $blogSettings->setValue( "plugin_tagcloud_min_size", $this->_minFont );
            $blogSettings->setValue( "plugin_tagcloud_max_size", $this->_maxFont );
            $blogSettings->setValue( "plugin_tagcloud_min_weight", $this->_minWeight );
            $blogSettings->setValue( "plugin_tagcloud_max_weight", $this->_maxWeight );
            $blogSettings->setValue( "plugin_tagcloud_banned_keywords", $this->_bannedKeywords );
            $blogSettings->setValue( "plugin_tagcloud_min_word_length", $this->_minWordLength );
            $this->_blogInfo->setSettings( $blogSettings ); 
		
			// save the blogs settings
			$blogs = new Blogs();
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new PluginTagCloudConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;
            }
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();
			
			$this->_view = new PluginTagCloudConfigView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("tagcloud_settings_saved_ok"));
			$this->setCommonData();

			$plugins = $this->_pm->getPlugins();

            $plugin = $plugins["tagcloud"];
            $plugin->createCloud();
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());			
            
            return true;		
		}
		
		function isValidColor($colorCode) {
		    $pattern = "#[a-fA-F0-9]{6}";
		    $length = strlen($colorCode);
            if (ereg ($pattern, $colorCode) && $length == 7) {
               return true;
            } else {
               return false;
            }
	    }
	}
?>