<?php

	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/secretblog/class/security/secretblogfilter.class.php" );
	
	class PluginSecretBlog extends PluginBase
	{
	
		function PluginSecretBlog( $source )
		{
			$this->PluginBase( $source );
			
			$this->id = "secretblog";
			$this->author = "The LifeType Project";
            $this->version = "20070522";
			
			// we only need to register a filter
            $this->registerFilter( "SecretBlogFilter" );

            if( $this->getSource() == "admin" ) {
                    // register our own actions
                    // register our action and menu entry
                $this->registerAdminAction( "pluginSecretBlogSettings", "AdminSecretBlogPluginSettingsAction" );
                $this->registerAdminAction( "pluginSecretBlogUpdateSettings", "AdminSecretBlogPluginUpdateSettingsAction" );			  
                
                    // register our action and menu entry
                $menu =& Menu::getMenu();
                if( !$menu->entryExists( "/menu/controlCenter/manageSecurityPlugins" ))                     
                    $this->addMenuEntry( "/menu/controlCenter", "manageSecurityPlugins", "", "", true, false );
                $this->addMenuEntry( "/menu/controlCenter/manageSecurityPlugins", "pluginSecretBlogSettings", "admin.php?op=pluginSecretBlogSettings", "", true, false );

            }
		}

            /**
             * export the list of globally configurable items
             */
        function getPluginConfigurationKeys()
            {
                return( Array( Array( "name" => "plugin_secretblog_enabled", "type" => "boolean" )));
            }
	}
?>