<?php

    lt_include( PLOG_CLASS_PATH."class/security/pipelinefilter.class.php" );
    lt_include( PLOG_CLASS_PATH . 'class/template/template.class.php' );


    class SecretBlogFilter extends PipelineFilter 
    {

        function SecretBlogFilter( $pipelineRequest )
        {
            $this->PipelineFilter( $pipelineRequest );
        }    

        function filter()
        {        
            // get some info
            $blogInfo     = $this->_pipelineRequest->getBlogInfo();
            $blogSettings = $blogInfo->getSettings();
            $request      = $this->_pipelineRequest->getHttpRequest();
            $session      = HttpVars::getSession();
            
        	// is the plugin enabled? If not, we can quit right away
        	if( !$blogSettings->getValue( "plugin_secretblog_enabled" )) {
	            $result =  new PipelineResult( true );
    	        return( $result );        	
        	}

            
            // if this is already rejected, there is no reason to do anything here
            if ( $this->_pipelineRequest->getRejectedState() )
                return new PipelineResult();


            // there are three possible situations:
            // - user not authenticated
            // - user not authenticated but blogPassword parameter in the request
            // - user authenticated
            
            
            if( $this->isUserAuthenticated( $blogInfo )) {            
	        $result =  new PipelineResult( true );
    	        return( $result );            
            }
            else {
            	// is there a "blogPassword" parameter in the session?
            	$password = $request->getValue( "blogPassword" );
            	if( $password ) {
            		// validate the password compared to whatever was stored in the blog settings
            		$blogSettings = $blogInfo->getSettings();
            		$blogPassword = $blogSettings->getValue( "plugin_secretblog_password" );
            		if( $blogPassword == md5( $password )) {
				// set the password in a cookie
				setcookie("blogPassword", md5( $password ));
            			// and return everything ok...
            			$result = new PipelineResult( true );
            			return( $result );
            		}
            		else {
            			// password wasn't correct, try again!
            			print( $this->renderPasswordForm( $blogInfo ));
            			die();
            		}
            	}
            	else {
            		// no password, no authentication info in the session!
					print( $this->renderPasswordForm( $blogInfo ));
					die();                        	
            	}            
            }
        }
        
        /**
         * @private
         * Returns true if the user has already been authenticated for this session
         */
        function isUserAuthenticated( $blogInfo )
        {
		// Get the password from the cookie
		$sessionPassword = $_COOKIE["blogPassword"];

        	if( $sessionPassword ) {        	
        		$blogSettings = $blogInfo->getSettings();
        		$blogPassword = $blogSettings->getValue( "plugin_secretblog_password" );
        		if( $sessionPassword == $blogPassword )
        			return true;
        		else
        			return false;
        	}
        	
        	else       		
        		return false;
        }
        
        /**
         * @private
         * Shows the authentication form
         */
        function renderPasswordForm( $blogInfo )
        {
			lt_include( PLOG_CLASS_PATH."class/template/templateservice.class.php" );        
			$ts = new TemplateService();
			$t = $ts->PluginTemplate( "secretblog", "passwordform" );
			$t->assign( "locale", $blogInfo->getLocale() );
			$t->assign( "articleId", $articleId );
			$t->assign( "url", $blogInfo->getBlogRequestGenerator());
			$t->assign( "blog", $blogInfo );
			return( $t->fetch());
        }
	}
?>