<?php
    /*
    Copyright 2006 Paul Westbrook (paul@westbrooks.org)
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    */
    

	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );


	class PluginRsd extends PluginBase
	{
		var $pluginEnabled;
		
		function PluginRsd( $source = "" )
		{
			$this->PluginBase($source);

			$this->id      = "rsd";
			$this->author  = "Paul Westbrook";
			$this->desc    = "Plugin to implement Really Simple Discovery.";
            $this->version = "20070311";

			$this->locales = Array( "en_UK");

			if( $source == "admin" )
				$this->initAdmin();
		}

		function initAdmin()
		{		
            if (defined( "EVENT_POST_ADMIN_PURGE_TEMP_FOLDER" )) {
                // register the events we want
                $this->registerNotification( EVENT_POST_ADMIN_PURGE_TEMP_FOLDER );
            }

            $this->registerAdminAction( "rsdConfig", "PluginRsdConfigAction" );
			$this->registerAdminAction( "updateRsdConfig", "PluginRsdUpdateConfigAction" );
			
			$menu =& Menu::getMenu();
			if( !$menu->entryExists( "/menu/controlCenter/manageIntegrationPlugins" ))						
				$this->addMenuEntry( "/menu/controlCenter", "manageIntegrationPlugins", "", "", true, false );			
            $this->addMenuEntry( "/menu/controlCenter/manageIntegrationPlugins", "rsd", "?op=rsdConfig", "" );
		}

		function register()
		{
		    $config =& Config::getConfig();

            $this->cacheFolder = $config->getValue('temp_folder');
            $this->cacheFolder = $this->cacheFolder.'/rsd/'.$this->blogInfo->getId();
            if( !File::exists( $this->cacheFolder )) {
                File::createDir( $this->cacheFolder );
            }

		    $blogSettings = $this->blogInfo->getSettings();
			$this->pluginEnabled = $blogSettings->getValue( "plugin_rsd_enabled" );
		}

	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }
	    
	    function show()
	    {
			$str = '';
	    
            if ($this->isEnabled())
            {
                $rg = $this->blogInfo->getBlogRequestGenerator();

                $rsdFile = "/rsd" . $this->blogInfo->getId() . ".xml";
                $rsdFileUrl = $rg->getUrl($rsdFile);
                
                $str = '<link rel="EditURI" type="application/rsd+xml" title="RSD" href="' . $rsdFileUrl . '" />';
             }
	    	return $str;
		}
		
        /**
         * process the events that we have registered
         *
         * @see PluginBase::process
         * @see PluginManager
         */
        function process( $eventType, $params )
        {
            // make sure we're processing the right event!
            if( !defined( "EVENT_POST_ADMIN_PURGE_TEMP_FOLDER" ) || $eventType != EVENT_POST_ADMIN_PURGE_TEMP_FOLDER ) 
            {
                return true;
            }

            // Load all of the settings for this blog
            $this->register();
            
            // make sure that the plugin is enabled
			if( !$this->isEnabled())
            {
                return true;
            }
                        
            $this->createRSD( );
              
            return true;
        }
        

		
		function createRSD()
		{
		    $rsdFile = $this->cacheFolder."/rsd.xml";  
            
            // Save this to a compressed file.
            $fd = fopen($rsdFile,'w9');

            if ( $fd )
            {

                // Data from the xml file that needs to be there.
                 $xmlData =  "<?xml version=\"1.0\" ?>\n".
                             "<rsd version=\"1.0\" xmlns=\"http://archipelago.phrasewise.com/rsd\" >\n".
                             "    <service>\n".
                             "<engineName>LifeType</engineName> \n".
                             "<engineLink>http://www.lifetype.net/</engineLink>\n";

                             
                fwrite($fd, $xmlData);
                
                $rg = $this->blogInfo->getBlogRequestGenerator();

                $xmlData = "<homePageLink>" . $rg->blogLink() . "</homePageLink>\n";
                fwrite($fd, $xmlData);
                
                fwrite($fd, "<apis>\n"); 

                $xmlrpcUrl = $rg->getUrl("/xmlrpc.php");

                $xmlData = "<api name=\"Movable Type\" preferred=\"true\" apiLink=\"" . $xmlrpcUrl . "\" blogID=\"" . $this->blogInfo->getId() . "\" />\n";
                fwrite($fd, $xmlData);

                $xmlData = "<api name=\"MetaWeblog\" preferred=\"false\" apiLink=\"" . $xmlrpcUrl . "\" blogID=\"" . $this->blogInfo->getId() . "\" />\n";
                fwrite($fd, $xmlData);

                $xmlData = "<api name=\"Blogger\" preferred=\"false\" apiLink=\"" . $xmlrpcUrl . "\" blogID=\"" . $this->blogInfo->getId() . "\" />\n";
                fwrite($fd, $xmlData);
                

                $xmlData =  "</apis>\n".
                            "</service>\n".
                            "</rsd>\n";
                fwrite($fd, $xmlData);
                fclose($fd);
            }                
		}
		
		function getPluginConfigurationKeys()
		{
			return( Array(
				Array( "name" => "plugin_rsd_enabled", "type" => "boolean" ),
			));
		}

	}
?>