<?php

    /*
    Copyright 2006 Paul Westbrook (paul@westbrooks.org)
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    */

	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );

	class PluginRequireEmail extends PluginBase
	{
		var $pluginEnabled;
		
		function PluginRequireEmail( $source = "" )
		{
			$this->PluginBase($source);

			$this->id      = "requireemail";
			$this->desc    = "The Require Email plugin requires that an email is entered for comments.";
			$this->author  = "Paul Westbrook";
			$this->locales = Array( "en_UK" );
            $this->version = "20070302";


			if( $source == "admin" )
				$this->initAdmin();
			else
				$this->init();
		}

		function init()
		{
            lt_include(PLOG_CLASS_PATH."plugins/requireemail/class/security/requireemailfilter.class.php");
            $this->registerFilter( "RequireEmailFilter" );
        }
        
        
		function initAdmin()
		{
            $this->init();

            $this->registerAdminAction( "requireemail", "PluginRequireEmailConfigAction" );
			$this->registerAdminAction( "updateRequireEmailConfig", "PluginRequireEmailUpdateConfigAction" );
			
			$menu =& Menu::getMenu();
			if( !$menu->entryExists( "/menu/controlCenter/manageAntiSpamPlugins" ))						
				$this->addMenuEntry( "/menu/controlCenter", "manageAntiSpamPlugins", "", "", true, false );			
            $this->addMenuEntry( "/menu/controlCenter/manageAntiSpamPlugins", "requireemail", "?op=requireemail", "" );            
		}

		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
			$this->pluginEnabled = $blogSettings->getValue( "plugin_requireemail_enabled" );
		}

	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }
	    
	    function getPluginConfigurationKeys()
		{			
			return( Array(
				Array( "name" => "plugin_requireemail_enabled", "type" => "boolean" ),
			));
		}

	}
?>