<?php
    /*
    Copyright 2006 Paul Westbrook (paul@westbrooks.org)
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    */
    

	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );

	class PluginReflection extends PluginBase
	{
		var $pluginEnabled;
		
		function PluginReflection( $source = "" )
		{
			$this->PluginBase($source);

			$this->id      = "reflection";
			$this->author  = "Paul Westbrook";
			$this->desc    = "Plugin to add reflections to images.";
            $this->version = "20070302";

			$this->locales = Array( "en_UK");

			if( $source == "admin" )
				$this->initAdmin();
		}

		function initAdmin()
		{
            $this->registerAdminAction( "reflectionConfig", "PluginReflectionConfigAction" );
			$this->registerAdminAction( "updateReflectionConfig", "PluginReflectionUpdateConfigAction" );
			
			$menu =& Menu::getMenu();
			if( !$menu->entryExists( "/menu/controlCenter/manageAppearancePlugins" ))						
				$this->addMenuEntry( "/menu/controlCenter", "manageAppearancePlugins", "", "", true, false );			
            $this->addMenuEntry( "/menu/controlCenter/manageAppearancePlugins", "reflection", "?op=reflectionConfig", "" );
		}

		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
			$this->pluginEnabled = $blogSettings->getValue( "plugin_reflection_enabled" );
		}

	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }
	    
	    function show()
	    {
			$str = '';
	    
            if ($this->isEnabled())
            {
                $rg = $this->blogInfo->getBlogRequestGenerator();
                
                $str = '<script type="text/javascript" src="' . $rg->blogLink() . '/plugins/reflection/class/js/reflection.js"></script>';
             }
	    	return $str;
		}
	}
?>