<?php

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );

define("RANDOMIMAGE_DEBUG", 1);

    /**
     * Plugin returns a randomly selected image from a given album
     */
    class PluginRandomImage extends PluginBase
    {
        function PluginRandomImage($source=""){
            $this->PluginBase($source);
  
            $this->id = "randomimage";
            $this->author = "Jon Daley";
            $this->desc = "This plugin offers a random image ".
                "from a specific album.";
            $this->version = "20070710";
            
            $this->locales = Array( "en_UK" );
        }

        /**
         * Returns the URL to a random image in $albumName
         * previewType can be "PREVIEW", "MEDIUM" or "FULL"
         */
        function getImage($albumName, $previewType){
            lt_include( PLOG_CLASS_PATH."class/gallery/dao/galleryalbums.class.php" );

            $blogId = $this->blogInfo->getId();

            $albums = new GalleryAlbums();
            $album = $albums->getAlbumByName($albumName, $blogId);
            if(!$album){
                if(RANDOMIMAGE_DEBUG)
                    return "no album '$albumName'";
                else
                    return "";
            }

            $resources = new GalleryResources();

                // get number of images in this album
            $numResources = $resources->getNumUserResources(
                -1, $album->getId(), GALLERY_RESOURCE_IMAGE);
                
            if($numResources <= 0){
                if(RANDOMIMAGE_DEBUG)
                    return ("no resources in album: ". $album->getId());
                else
                    return "";
            }
            
            $whichResource = rand(0, $numResources-1);
            
            $query = "SELECT id FROM ".Db::getPrefix()."gallery_resources ".
                "WHERE album_id = '".$album->getId()."' ".
                "AND resource_type='".GALLERY_RESOURCE_IMAGE."' ".
                "LIMIT $whichResource, 1";

            $db =& Db::getDb();
            $result = $db->Execute( $query ); 
            
            if(!$result){
                if(RANDOMIMAGE_DEBUG)
                    return "bad query '".$query."'";
                else
                    return "";
            }

            if(!($row = $result->FetchRow())){
                if(RANDOMIMAGE_DEBUG)
                    return "no results";
                else
                    return "";
            }

            $resource = $resources->getResource($row["id"]);
            if(!$resource){
                if(RANDOMIMAGE_DEBUG)
                    return "bad resource: '".$row["id"]."'";
                else
                    return "";
            }

            $rg = $this->blogInfo->getBlogRequestGenerator();
            if($previewType == "FULL")
                return $rg->resourceDownloadLink($resource);
            else if($previewType == "MEDIUM")
                return $rg->resourceMediumSizePreviewLink($resource);
            else
                return $rg->resourcePreviewLink($resource);

        }
        
    }
?>