<?php

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );    
    lt_include( PLOG_CLASS_PATH."plugins/plogeshi/class/plogeshi/plogeshi.class.php" );

    define( "PLOGESHI_PATH", PLOG_CLASS_PATH . "plugins/plogeshi/" );
    define( "PLOGESHI_GESHI_PATH", PLOGESHI_PATH ."inc/" );
    
    class PluginPloGeSHi extends PluginBase
    {
        var $_pluginEnabled;
        var $_ploGeshi;

        function PluginPloGeSHi( $source = "" )
        {
			$this->PluginBase($source);

            // ---
            // set some information
            // ---
            $this->id = "plogeshi";
            $this->version = "20070226";
            $this->author = "Rodrigo Prez (bilson)";
            $this->desc = "This plugin allows to color bits of code using GeSHi. Please use the following syntax
                          anywhere in your posts:<br/><br/>
                          &lt;code php&gt;<br/>
                          &nbsp;&nbsp; // place here your PHP code here<br/>
                          &nbsp;&nbsp;...<br/>
                          &lt;/code&gt;
                          <br/><br/>
                          Other common formats supported by <a href=\"http://qbnz.com/highlighter/\">GeSHi</a>
                          include: <b>Actionscript, ASM, ASP, Bash, C,
                          C#, C++, CSS, Delphi, HTML, Java, Javascript, Lisp,
                          Objective C,
                          Pascal, Perl, PHP, Python, Smarty, SQL, VB.NET, Visual BASIC, XML</b>.<br/><br/>
                          Simply enclose your code within &lt;code <i>code-identifier</i>&gt;...&lt;/code&gt;
                          and use any of the languages above as the value for <i>code-identifier</i>.";
                            
            $this->_ploGeshi = new PloGeSHi();
            
    
			if( $source == "admin" )
				$this->initAdmin();
			else
				$this->init();
        }

        function init()
        {
            // ---
            // register the event we are going to need
            $this->registerNotification( EVENT_TEXT_FILTER );        
        }
        
        function initAdmin()
        {
            // ---
            // register actions for this plugin plus an option in the menu
            // ---
            $this->registerAdminAction( "PloGeSHiConfig", "PluginPloGeSHiConfigAction" );
            $this->registerAdminAction( "updatePloGeSHiConfig", "PluginPloGeSHiUpdateConfigAction" );
            
            // ---
            // register actions for this plugin plus an option in the menu
            // ---
            $menu =& Menu::getMenu();
            $this->addMenuEntry( "/menu/Manage/managePosts", "PloGeSHi", "admin.php?op=PloGeSHiConfig", "" );
            
        }

        function register()
        {
            $blogSettings = $this->blogInfo->getSettings();
            $this->_pluginEnabled = $blogSettings->getValue( "plugin_plogeshi_enabled" );
        }

        function isEnabled()
        {
            return $this->_pluginEnabled;
        }

        
        
        function _colorText( $post  )
        {
            // modify the text...
            return $this->_ploGeshi->colorText( $post );
        }
        
        function FShouldColorText( $post )
        {
            // This is currently only checking to see if this post has some 
            // visible text
            //
            // This logic matches the logic in Article::hasExtendedText()
            
            // This code really should be looking at the text for the 
            // <code > tag
          
		    $postText = trim($post);

		    if ( !preg_match( "/[code\s+\w+\s*]/i", $post ) ||
        		 !preg_match( "/[\/code]/", $post ) ) {
        		return false;
    		} else {
        		return( strlen($postText) > 0 );
    		}	
        }
        
        /**
         * Receives and processes events
         *
         * @param eventType
         *@param params
         */
        function process( $eventType, $params )
        {
            // if the plugin is diabled, return
            $settings = $this->blogInfo->getSettings();
            if( !$settings->getValue( "plugin_plogeshi_enabled" ))
                return true;

            // prevent other events
            if( $eventType != EVENT_TEXT_FILTER ) {
                    throw( new Exception( "PloGeshi only receive EVENT_TEXT_RENDER events" ));
                    die();
            }

            if( $this->FShouldColorText( $params[ "text" ] ) )
            { 
                // Only bother modifying the text if there is a potential that there is a [code] tag
                $rg =& $this->blogInfo->getBlogRequestGenerator();
                $baseUrl = $rg->getBaseUrl();
                $cssUrl = $baseUrl."/plugins/plogeshi/styles/plogeshi.css";
        
                $css = '<link rel="stylesheet" type="text/css" href="' . $cssUrl . '" />';
                $params[ "text" ] = $css . $this->_colorText( $params[ "text" ] );
            }
        }


   	    function getPluginConfigurationKeys()
		{
			return( Array(
				Array( "name" => "plugin_plogeshi_enabled", "type" => "boolean" ),
			));
		}

    }
?>