<?php

	lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
		
	/**
	 * change this constant in case you want to redefine the limit for nested
	 * comments
	 */
	define( "MAX_NESTED_COMMENTS", 6 );

	class PluginNestedComments extends PluginBase
	{
		
		function PluginNestedComments()
		{
			$this->id = "nestedcomments";
			$this->author = "The LifeType Project";
			$this->locales = Array();
            $this->version = "20070226";
			
			// description
			$this->desc = <<<EOD
This plugin will generate a nested list of comments. In order to use it, edit your postandcomments.template file
and add the following line:
<pre>
   {assign var=comments value=\$nestedcomments->getNestedComments(\$post)}
</pre>
just above this line:
<pre>
   {foreach from=\$comments item=comment}
</pre>
Nesting is applied by using CSS classes to increase the left margin of the div block of the comment. The recommended
implenentation looks like this:
<pre>
   {assign var=comments value=\$nestedcomments->getNestedComments(\$post)}
   {foreach from=\$comments item=comment}
     &lt;div class="comment_{\$comment->getValue("depth")}"&gt;
      {\$comment->getTopic()}&lt;br/&gt;
      {\$comment->getText()}&lt;br/&gt;
     &lt;/div&gt;
   {/foreach}
</pre>
Please notice that we are defining several different "comment_X" CSS classes that should be defined in our
CSS file:
In order to apply different graphical styles for different levels of nesting, define up to 6
"comment_X" CSS classes (as in "comment_1", "comment_2", "comment_3", etc) in the CSS file used
by your template set:
<pre>
    .comment_1 {
     margin-left: 10px;
    }
    .comment_2 {
     margin-left: 20px;
    }
    .comment_3 {
     margin-left: 30px;
    }
    ...
    .comment_6 {
     margin-left: 60px;
    }
</pre>
By default there can only
be up to 6 levels of nesting but this limit is configurable by editing the plugin file.
EOD;
		}
		
		/**
		 * @private
		 */
		function _nestComments( $comments, $allComments, $depth = 0 )
		{
		  $result = Array();
		  foreach( $comments as $comment ) {
		      if( $depth > MAX_NESTED_COMMENTS )
		          $depth = MAX_NESTED_COMMENTS;
		      $comment->setValue( "depth", $depth+1 );		      
		      $result[] = $comment;
		      if( isset($allComments[$comment->getId()]))
		          $result = array_merge( $result, $this->_nestComments( $allComments[$comment->getId()], $allComments, $depth+1 ));
		  }
		  return( $result );		  
		}

        /**
         * returns an array with the comments already sorted in the same way as they should
         * be nested. Use $comment->getValue( "depth" ) in order to know how deeply the comment
         * should be nested.
         *
         * @param post
         * @return An array of of UserComment objects
         */
		function getNestedComments( $post )
		{
			$nestedComments = Array();                                            
			$postComments = $post->getComments();
			
			// if there are no comments for this post, we should
			// prevent the php warning by returning for example an
			// empty array
			if( !is_array( $postComments ))
				return( Array());
            if( empty($postComments ))
                return( Array());
			
			foreach( $postComments as $comment ) {
				$key = $comment->getParentId();
				if( $nestedComments["$key"] == "" )
					$nestedComments["$key"] = Array();
						
				$nestedComments["$key"][] = $comment;					
			}

		    $comments = $this->_nestComments( $nestedComments[0], $nestedComments );
		    
		    return($comments);
		}
	}
?>