<?php

	lt_include( PLOG_CLASS_PATH."class/dao/articlecomments.class.php" );
	
	// value for the status field of a comment, to let us know that it is in unmoderated status
	define( "COMMENT_STATUS_UNMODERATED", 9 );
	
	/**
	 * extends the ArticleComents class to add some methods not available in it
	 */
	class UnmoderatedComments extends ArticleComments
	{
	
		function UnmoderatedComments()
		{
			$this->ArticleComments();
		}
		
		function getUnmoderatedComments( $blogId )
		{
			$prefix = $this->getPrefix();
			$query = "SELECT *
			          FROM {$prefix}articles_comments
					  WHERE blog_id = $blogId AND status = ".COMMENT_STATUS_UNMODERATED."
					  ORDER BY date ASC";
					  
			$result = $this->Execute( $query );
			
			// return an empty array if there was any problem
			if( !$result )
				return Array();
				
			// or else, loop through the array
			$comments = Array();
			while( $row = $result->FetchRow()) {
				array_push( $comments, $this->mapRow( $row ));
			}
			
			return $comments;
		}
	}
?>