<?php

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
    lt_include( PLOG_CLASS_PATH."plugins/moblog/class/security/moblogbatchfilter.class.php" );
    
    /**
     * implementation a plugin to give Lifetype moblogging features (posting via email)
     */
    class PluginMoblog extends PluginBase
    {
    
        function PluginMoblog( $source )
        {
            $this->id = "moblog";
            $this->author = "The Lifetype Project";
            $this->locales = Array();
			$this->version = "20070622";
            $this->desc = "
Send a message with the following format ('start' and 'end' messages not included!):<br/>
<br/>
--- start of moblog message format ---<br/>
<br/>
USER: your-lifetype-username<br/>
PASS: your-lifetype-password<br/>
BLOG: your-lifetype-blog-name<br/>
<br/>
--- end of moblog message format ---<br/>
<br/>
The must be sent as plain text, and it can include as many attachment as needed.";

            $this->init();
        }
        
		/**
		 * set some actions and menu options
		 * @private
		 */
		function init()
		{
			// register the filter
			if( $this->getSource() == "index" ) {
				$this->registerFilter( "MoblogBatchFilter" );
			}
			else {
				// register actions
				$this->registerAdminAction( "moblogSettings", "AdminMoblogPluginSettingsAction" );
				$this->registerAdminAction( "updateMoblogSettings", "AdminMoblogPluginUpdateSettingsAction" );
				$this->registerAdminAction( "moblogbatchSettings", "AdminMoblogBatchPluginSettingsAction" );
				$this->registerAdminAction( "updateMoblogBatchSettings", "AdminMoblogBatchPluginUpdateSettingsAction" );


				// register menu entries
				$this->addMenuEntry( "/menu/controlCenter/manageSettings",   // menu path
	                                             "moblogSettings",    // menu id
	                                             "admin.php?op=moblogSettings",     // url
	                                             "Moblog"    // text to show
	                                            );
				$this->addMenuEntry( "/menu/adminSettings/GlobalSettings", "moblogbatchSettings", "admin.php?op=moblogbatchSettings", "" );
			}
		}        
    }
?>