<?php

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
    
    if( !defined( "MOBILE_PLOG_CLASS_PATH" )) {
        define( "MOBILE_PLOG_CLASS_PATH", PLOG_CLASS_PATH."plugins/mobile/" );
    }        
    
    class PluginMobile extends PluginBase
    {
    
        function PluginMobile()
        {
            $this->PluginBase();
            
            $this->id = "mobile";
            $this->desc = "Allows LifeType blogs to be accessed via mobile terminals";
            $this->author = "The LifeType Project";
            $this->version = "20070226";
        }
     
        /** 
         * Returns a link to the mobile view of the current blog
         *
         * @return A valid URL
         */   
        function blogLink()
        {
            lt_include( MOBILE_PLOG_CLASS_PATH."class/net/mobilerequestgenerator.class.php" );
            $murl = new MobileRequestGenerator( $this->blogInfo );
            return( $murl->getMobileUrl()."?blogId=".$this->blogInfo->getId()); 
        }

        /** 
         * Returns a link to the mobile view of a post
         *
         * @param blog A valid BlogInfo object
         * @return A valid URL
         */           
        function articleLink( $article )
        {
            lt_include( MOBILE_PLOG_CLASS_PATH."class/net/mobilerequestgenerator.class.php" );
            $murl = new MobileRequestGenerator( $this->blogInfo );
            return( $murl->getMobileUrl()."?op=ViewArticle&amp;blogId=".$this->blogInfo->getId()."&amp;articleId=".$article->getId());         
        }
    }
?>