<?php

    
    lt_include( PLOG_CLASS_PATH."plugins/mobile/class/net/terminalinfo.class.php" );
    lt_include( PLOG_CLASS_PATH."class/config/config.class.php" );
    
    class TerminalIdentifier
    {
    
        var $_headers;
        var $_terminals;
    
        function TerminalIdentifier()
        {
            
            
            $this->_loadTerminalDefinition();
        }
        
        /**
         * @private
         */
        function _loadTerminalDefinition()
        {
            $config =& Config::getConfig( "file", Array( "file" => PLOG_CLASS_PATH."plugins/mobile/config/terminal.properties.php" ));
            
            // load the "terminals" key, which is an array of arrays with the definition of
            // each terminal
            $this->_terminals = $config->getValue( "terminals" );
        }
        
        /** 
         * @return TerminalInfo
         */
        function identify( $headers )
        {
            $this->_headers = $headers;
            
            $userAgent = $headers[ "HTTP_USER_AGENT" ];
            
            // loop through the definition of each one of the terminals
            //foreach( $this->_terminals as $terminalDef ) {
            $matches = false;
            $i = 0;
            while( $i < count($this->_terminals ) && !$matches ) {
                $terminalDef = $this->_terminals[$i];
                //print("terminal = ".$terminalDef["id"]."<br/>" );
                // check if the terminal regexp matches with the user-agent string
                if( preg_match( $terminalDef["regexp"], $userAgent, $matches )) {
                    $matches = true;
                }
                $i++;
            }
            
            //
            // if nothing matched, then there's nothing for us to do here
            //
            if( !$matches ) {
                print("No matches found!");
                return( null );
            }
            
            //
            // if something matched, build the correct TerminalInfo object
            //
            $info = new TerminalInfo( $terminalDef, $headers );
            
            return( $info );
        }
    }
?>