<?php
    
    lt_include( MOBILE_PLOG_CLASS_PATH."class/action/mobileaction.class.php" );
    lt_include( MOBILE_PLOG_CLASS_PATH."class/view/mobileerrorview.class.php" );
    lt_include( MOBILE_PLOG_CLASS_PATH."class/view/mobileviewarticleview.class.php" );    
    lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
    lt_include( PLOG_CLASS_PATH."class/dao/articles.class.php" );
    
    class MobileViewArticleAction extends MobileAction
    {
    
        function MobileViewArticleAction( $actionInfo, $request )
        {
            $this->MobileAction( $actionInfo, $request );
            
            $this->registerFieldValidator( "articleId", new IntegerValidator());
            $view = new MobileErrorView( $this->_blogInfo, $this->_tInfo );
            $view->setErrorMessage( $this->_locale->tr("error_invalid_blog_id" ));
            $this->setValidationErrorView( $view );
        }
    
        function perform()
        {
            // load the article
            $this->_articleId = $this->_request->getValue( "articleId" );
            $articles = new Articles();
            $article = $articles->getBlogArticle( $this->_articleId, $this->_blogInfo->getId());
            
            // was it correct?
            if( !$article ) {
                $this->_view = new MobileErrorView( $this->_blogInfo, $this->_tInfo );
                $this->_view->setErrorMessage( $this->_locale->tr( "incorrect_blog_id" ));
                $this->setCommonData();
                return( false );
            }
            
            // if so, continue
            $this->_view = new MobileViewArticleView( $this->_blogInfo, $this->_tInfo );
            $this->_view->setValue( "post", $article );
            $this->setCommonData();
            
            return( true );
        }
    }
?>