<?php

	lt_include( PLOG_CLASS_PATH."class/action/blogaction.class.php" );
	lt_include( PLOG_CLASS_PATH."class/view/blogtemplatedview.class.php" );
    lt_include( PLOG_CLASS_PATH."class/dao/blogs.class.php" );
    lt_include( PLOG_CLASS_PATH."class/view/errorview.class.php" );
	lt_include( PLOG_CLASS_PATH."class/plugin/pluginmanager.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/articles.class.php" );	

    /**
     * Allows users to browse moderated down articles, otherwise they cannot
	 * be accessed via the common means
     */
	class ViewModeratedDownArticleAction extends BlogAction
    {

        var $_articleId;

		function ViewModeratedDownArticleAction( $actionInfo, $request )
        {
			$this->BlogAction( $actionInfo, $request );
        }
        
        // checks that the articleId is valid
        function validate()
        {
        	$this->_articleId = $this->_request->getValue( "articleId" );			
            return true;
        }
		
		function _setErrorView()
		{
			$this->_view = new ErrorView( $this->_blogInfo );
			$this->_view->setValue( "message", $this->_locale->tr("error_fetching_moderated_down_article") );
			$this->setCommonData();		
		}

        function perform()
        {
            // fetch the article
            $articles = new Articles();
			$articles->_db->debug=false;
			$article  = $articles->getBlogArticle( $this->_articleId, $this->_blogInfo->getId(), 
			                                       false, -1, -1, -1, POST_STATUS_KARMA_MODERATED_DOWN );
													   
            // if the article id doesn't exist, cancel the whole thing...
            if( !$article ) {
				$this->_setErrorView();
                return false;
            }				
				
            $nextArticle = $articles->getBlogNextArticle( $article );
            $prevArticle = $articles->getBlogPrevArticle( $article );
            $blogSettings = $this->_blogInfo->getSettings();

        	$this->_view = new BlogTemplatedView( $this->_blogInfo , "postandcomments" );

            // check if we have to update how many times an article has been read
            if( $this->_config->getValue( "update_article_reads" )) {
            	$curReads = $article->getNumReads();
            	$article->setNumReads( $curReads + 1 );
                $articles->updateArticleNumReads( $article->getId(), $curReads + 1 );
            }

            $this->setCommonData();
			
			// mandatory call to the plugin manager
			$pm =& PluginManager::getPluginManager();
			$pm->setBlogInfo( $this->_blogInfo );
			$pm->setUserInfo( $this->_userInfo );
			$pm->notifyEvent( EVENT_POST_LOADED, Array( "article" => &$article ));
			
            // if everything's fine, we set up the article object for the view
            $this->_view->setValue( "post", $article );
            $this->_view->setValue( "nextpost", $nextArticle );
            $this->_view->setValue( "prevpost", $prevArticle );
            $this->_view->setValue( "user", $article->getUser());
            $this->_view->setValue( "trackbacks", $article->getTrackbacks());
            $this->_view->setValue( "referers", $articleReferers );
			
            // and return everything normal
            return true;
        }
    }
?>