<?php

	lt_include( PLOG_CLASS_PATH."class/action/blogaction.class.php" );
    lt_include( PLOG_CLASS_PATH."class/view/defaultview.class.php" );
    lt_include( PLOG_CLASS_PATH."class/dao/articles.class.php" );
    lt_include( PLOG_CLASS_PATH."class/dao/blogs.class.php" );
    lt_include( PLOG_CLASS_PATH."class/dao/blogsettings.class.php" );
    lt_include( PLOG_CLASS_PATH."class/view/errorview.class.php" );
    lt_include( PLOG_CLASS_PATH."class/dao/referers.class.php" );
	lt_include( PLOG_CLASS_PATH."class/plugin/pluginmanager.class.php" );	
	lt_include( PLOG_CLASS_PATH."class/view/plugintemplatedview.class.php");

    /**
     * shows all the posts that have been moderated down
     */
	class ViewModeratedDownAction extends BlogAction 
	{

		function ViewModeratedDownAction( $actionInfo, $request )
        {
			$this->BlogAction( $actionInfo, $request );
        }

        function perform()
        {
			// fetch all the articles from that blog
            $articles =  new Articles();
			
            $t = new Timestamp();
            $todayTimestamp = $t->getTimestamp();
			
			$this->_postAmount = -1;
			// also, inform the template that we're showing them all!
			$this->_view =  new PluginTemplatedView( $this->_blogInfo, "karma", "moderateddownlist", SMARTY_VIEW_CACHE_DISABLED );
			
			$this->_view->setValue( "showAll", true );
			// another flag indicating that we are showing the list of moderated down posts
			$this->_view->setValue( "showModeratedDown", true );
			$blogSettings = $this->_blogInfo->getSettings();
			$blogId = $this->_blogInfo->getId();
			
			$blogArticles = $articles->getBlogArticles( $blogId, -1, -1, 0, POST_STATUS_KARMA_MODERATED_DOWN );

            // if we couldn't fetch the articles, send an error and quit
            if( $blogArticles == false ) {
            	$this->_view = new ErrorView( $this->_blogInfo );
                $this->_view->setValue( "message", $this->_locale->tr("error_fetching_moderated_down_articles") );
            }
			
			// this is a little kludge... but it needs to be fixed!! 
			$pm =& PluginManager::getPluginManager();
			$pm->setBlogInfo( $this->_blogInfo );
			$pm->setUserInfo( $this->_userInfo );
			$result = $pm->notifyEvent( EVENT_POSTS_LOADED, Array( "articles" => &$blogArticles ));
			$this->_view->setValue( "moderateddown", $blogArticles );
            $this->setCommonData();
            $this->saveSession();

            return true;
        }
    }
?>