<?php
	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/iconize/class/view/pluginiconizeconfigview.class.php" );	
		
	/**
	 * updates the plugin configuration
	 */
	class PluginIconizeUpdateConfigAction extends AdminAction
	{
		var $_pluginEnabled;
		var $_iconize;
		
		function PluginIconizeUpdateConfigAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );
		}
		
		function validate()
		{
            $errorMessages = array();
			$this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
            $this->_pluginEnabled = ($this->_pluginEnabled != "" );
			
			if( count($errorMessages) > 0 ) {
                $this->_view = new PluginIcoNizeConfigView( $this->_blogInfo );
				$allerror='';
				foreach( $errorMessages as $error ){
					$allerror .= $this->_locale->tr($error).'<br />';
				}
		$this->_view->setErrorMessage( $this->_locale->tr($allerror));
                $this->setCommonData();
                return false;
            }        	                
			
			return true;
		}
		        
		function perform()
		{
            // // update the plugin configurations to blog setting
			$blogSettings = $this->_blogInfo->getSettings();
            $blogSettings->setValue( "plugin_iconize_enabled", $this->_pluginEnabled );
            $this->_blogInfo->setSettings( $blogSettings ); 
		
			// save the blogs settings
			$blogs = new Blogs();
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new PluginIconizeConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;
            }
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();

			$this->_view = new PluginIconizeConfigView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("iconize_settings_saved_ok"));
			$this->setCommonData();
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());				
            
            return true;		
		}
	}
?>
