<?php

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
    lt_include( PLOG_CLASS_PATH."class/plugin/pluginmanager.class.php" );
    
    /**
     * Plugin that offers features to return a recent article comments from the current blog
     */
    class PluginHotlinkPrevention extends PluginBase
    {
        var $pluginEnabled;
        var $allowBlogOwnerOverride;
        
        function PluginHotlinkPrevention( $source = "" )
        {
            $this->PluginBase($source);
  
            $this->id = "hotlinkprevention";
            $this->author = "Mark Wu";
            $this->desc = "This plugin offers the hotlink prevention to resource.";
            $this->version = "20070320";
              
            $this->locales = Array( "en_UK" , "zh_TW" );
            
			if( $source == "admin" )
				$this->initAdmin();
        }

		function initAdmin()
		{
            $this->registerAdminAction( "hotlinkprevention", "PluginHotlinkPreventionConfigAction" );
			$this->registerAdminAction( "updateHotlinkPreventionConfig", "PluginHotlinkPreventionUpdateConfigAction" );
			
            $menu =& Menu::getMenu();
            if( !$menu->entryExists( "/menu/controlCenter/manageSecurityPlugins" ))
                $this->addMenuEntry( "/menu/controlCenter", "manageSecurityPlugins", "", "", true, false );
            $this->addMenuEntry( "/menu/controlCenter/manageSecurityPlugins", "HotlinkPrevention", "?op=hotlinkprevention", "" );
		}
		
		
        function register()
        {            
           $blogSettings = $this->blogInfo->getSettings();
           $this->pluginEnabled = $blogSettings->getValue( "plugin_hotlinkprevention_enabled" );
    
        }
        
        function isEnabled()
        {
            return $this->pluginEnabled;
        }        


	/*
	* Return cloud of the latest articles
	*/
	function UpdateHtAccess(){
        lt_include( PLOG_CLASS_PATH."class/gallery/dao/galleryresourcestorage.class.php" );

        $resourceStorage = new GalleryResourceStorage();

        $resourceFolder = $resourceStorage->getResourcesStorageFolder();

		$blogId = $this->blogInfo->getId();
        $blogSettings = $this->blogInfo->getSettings();

        // Create the path to the resource .htaccess file for this blog
        $saveFile = $resourceFolder . $blogId . "/.htaccess";

        if ($blogSettings->getValue( "plugin_hotlinkprevention_enabled" )){
           $this->CreateHtAccess($saveFile);
        } else {
            $this->DeleteHtAccess($saveFile);
        }
            
            
        return true;
    }
    
   function DeleteHtAccess($htaccessFile){
        unlink($htaccessFile);
   }
    
	function CreateHtAccess($htaccessFile){
		$blogId = $this->blogInfo->getId();
        $blogSettings = $this->blogInfo->getSettings();

        $fileExtensions = $blogSettings->getValue( "plugin_hotlinkprevention_fileextensions" );
        $extArray = explode( " ", $fileExtensions );
        
        $allowReferers = $blogSettings->getValue( "plugin_hotlinkprevention_allowreferers" );

    
        // Only create the .htaccess if at least one extension has been specified
        if (count($extArray) > 0)
        {
            $fh = fopen( $htaccessFile, "w");
    
            if ($fh) {

                fwrite($fh, "RewriteEngine on\n");
                fwrite($fh, "RewriteBase /\n");

                $rewriteExtCond = "RewriteCond %{REQUEST_FILENAME} \.(";
                
                $count = 0;
                
                foreach($extArray as $fileExtension ) {
                    trim($fileExtension);
                    if( $fileExtension != "" && $fileExtension != " " ) {
                        if ($count > 0) {
                            $rewriteExtCond .= "|";
                        }
                        
                        $rewriteExtCond .= $fileExtension;
                        
                        $count++;
                    } 
                }			
                
                $rewriteExtCond .= ")$ [NC]\n";
    
                fwrite($fh, $rewriteExtCond);
                
                $blankRefererEnabled = $blogSettings->getValue( "plugin_hotlinkprevention_blankrefererenabled" );
                if ($blankRefererEnabled) {
                    fwrite($fh, "RewriteCond %{HTTP_REFERER} !^$\n");                    
                }
                
                
                foreach(preg_split("/[\s]+/", $allowReferers ) as $allowReferer ) {
			       	trim($allowReferer);
			       	if( $allowReferer != "" && $allowReferer != "\r\n" && $allowReferer != "\r" && $allowReferer != "\n" ) {
                        fwrite($fh, "RewriteCond %{HTTP_REFERER} !^" . $allowReferer . " [NC]\n");
			    	}
			    }

                fwrite($fh, "RewriteRule ^(.*)   -  [F]\n");

                fwrite($fh, "ErrorDocument 403 \"Hot linking is not allowed\"\n");
	    
               fclose($fh);
               File::chMod($htaccessFile, 0644);
            }
        } else {
            $this->DeleteHtAccess($htaccessFile);
        }
    }
    
    

        function getPluginConfigurationKeys()
		{			
            lt_include( PLOG_CLASS_PATH."class/data/validator/stringvalidator.class.php" );

			return( Array(
				Array( "name" => "plugin_hotlinkprevention_enabled", "type" => "boolean" ),
				Array( "name" => "plugin_hotlinkprevention_fileextensions", "validator" => new StringValidator(), "type" => "string", "allowEmpty" => true ),
				Array( "name" => "plugin_hotlinkprevention_blankrefererenabled", "type" => "boolean" ),
				Array( "name" => "plugin_hotlinkprevention_allowreferers", "validator" => new StringValidator(), "type" => "string", "allowEmpty" => true ),
			));
		}

    }
?>