<?php

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
    
    /**
     * Plugin that offers hidden fields to comment form to prevent spammer post from spam robot
     */
    class PluginHiddenInput extends PluginBase
    {
        var $prefix;
        var $pluginEnabled;
        var $hiddenFields;
           
        function PluginHiddenInput($source = "")
        {
            $this->PluginBase($source);
  
            $this->id = "hiddeninput";
            $this->author = "Mark Wu";
            $this->desc = "This plugin offers hidden fields to comment form to prevent spammer post from spam robot.";
            $this->version = "20070314";
            
            $this->prefix = Db::getPrefix();
            
            $this->locales = Array( "en_UK" , "zh_TW" );
            
			if( $source == "admin" )
				$this->initAdmin();
			else
				$this->init();
        }

		function init()
		{
            lt_include( PLOG_CLASS_PATH."plugins/hiddeninput/class/security/hiddeninputfilter.class.php" );
			$this->registerFilter( "HiddenInputFilter" );
		}

		function initAdmin()
		{
            $this->registerAdminAction( "hiddeninput", "PluginHiddenInputConfigAction" );
			$this->registerAdminAction( "updateHiddenInputConfig", "PluginHiddenInputUpdateConfigAction" );
			
			$menu =& Menu::getMenu();
			if( !$menu->entryExists( "/menu/controlCenter/manageAntiSpamPlugins" ))
				$this->addMenuEntry( "/menu/controlCenter", "manageAntiSpamPlugins", "", "", true, false );
            $this->addMenuEntry( "/menu/controlCenter/manageAntiSpamPlugins", "HiddenInput", "?op=hiddeninput", "" );
		}

		function register()
		{
		    $blogSettings = $this->blogInfo->getSettings();
		    $this->pluginEnabled = $blogSettings->getValue( "plugin_hiddeninput_enabled" );
	        $this->hiddenFields = $blogSettings->getValue( "plugin_hiddeninput_hiddenfields" );
	    }
	    
	    function isEnabled()
	    {
	        return $this->pluginEnabled;
	    }
	    
	    function getHiddenFields()
	    {
            $commentHiddenFields = Array();

            if($this->isEnabled()){
                $hiddenFieldsList = explode(",", $this->hiddenFields);
                
                foreach( $hiddenFieldsList as $hiddenField ) {
                    array_push($commentHiddenFields, trim($hiddenField));
                }
            }
            return $commentHiddenFields;
        }

	    function printHiddenFields()
        {
            lt_include(PLOG_CLASS_PATH."plugins/hiddeninput/class/dao/hiddeninput.class.php");
            print "<style>.hidinp { display: none }</style>\n";
            foreach($this->getHiddenFields() as $hiddenField){
                print "<input class='hidinp' type='text' ".
                    "name='$hiddenField' value='".
                    HiddenInput::generateValue($this->blogInfo->getSettings(), $hiddenField).
                    "' />\n";
            }
        }
        
        function getPluginConfigurationKeys(){
			lt_include(PLOG_CLASS_PATH."class/data/validator/stringvalidator.class.php");
            return (Array(
                        Array("name" => "plugin_hiddeninput_enabled",
                              "type" => "boolean"),
                        Array("name" => "plugin_hiddeninput_hiddenfields",
                              "validator" => new StringValidator(),
                              "type" => "string", "allowEmpty" => true ),
                        Array("name" => "plugin_hiddeninput_emptyfields",
                              "validator" => new StringValidator(),
                              "type" => "string", "allowEmpty" => true ),
                        ));
        }
    }
?>