<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/gravatar/class/view/plugingravatarconfigview.class.php" );		

		
	/**
	 * updates the plugin configuration
	 */
	class PluginGravatarUpdateConfigAction extends AdminAction
	{
		var $_pluginEnabled;
		var $_rating;
		var $_default;
		var $_size;
		
		function PluginGravatarUpdateConfigAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );
		}
		
		function validate()
		{
            $this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
            $this->_pluginEnabled = ($this->_pluginEnabled != "" );
            $this->_rating = $this->_request->getValue( "rating" );
            $this->_default = $this->_request->getValue( "default" );
            $this->_size = $this->_request->getValue( "size" );

			return true;
		}
		        
		function perform()
		{
            // // update the plugin configurations to blog setting
			$blogSettings = $this->_blogInfo->getSettings();
            $blogSettings->setValue( "plugin_gravatar_enabled", $this->_pluginEnabled );
            $blogSettings->setValue( "plugin_gravatar_rating", $this->_rating );
            $blogSettings->setValue( "plugin_gravatar_default", $this->_default );
            $blogSettings->setValue( "plugin_gravatar_size", $this->_size );            
            $this->_blogInfo->setSettings( $blogSettings ); 
		
			// save the blogs settings
			$blogs = new Blogs();
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new PluginGravatarConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;
            }
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();
			
			$this->_view = new PluginGravatarConfigView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("gravatar_settings_saved_ok"));
			$this->setCommonData();
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());			
            
            return true;		
		}
	}
?>