<?php

    lt_include( PLOG_CLASS_PATH."class/action/blogaction.class.php" );
    lt_include( PLOG_CLASS_PATH."class/view/plugintemplatedview.class.php" );
    lt_include( PLOG_CLASS_PATH."class/gallery/dao/galleryresources.class.php" );
    
    /**
     * This is the class that is executed when index.php receives an "op"
     * parameter called "GenerateSmilAction". Plugins can register as many
     * actions as they wish, as long as they use $this->registerBlogAction()
     */
    class GenerateFeedAction extends BlogAction
    {
    
        var $_albumId;
    
        /**
         * this makes sure that our parameters are correct and sets the album id 
         * to '1' in case the parameter is not correct. This method would need some additional work,
         * should this plugin ever be released :)
         */
        function validate()
        {
            // make sure that the album id is correct and if not, set it to
            // a harmless value such as '1' (though this probably would need to be changed!)
            $this->_albumId = $this->_request->getValue( "albumId" );
            $val = new IntegerValidator();
            if( !$val->validate( $this->_albumId ))
                $this->_albumId = 1;
                
            $this->_feedType = $this->_request->getValue( "feed" );
            // check if the feed type is correct and if not use the default "rss20" one
            if( !File::isReadable( PLOG_CLASS_PATH."plugins/galleryfeeds/templates/".$this->_feedType.".template" ))
                $this->_feedType = "rss20";
                
            return( true );
        }
        
        /**
         * returns the right MIME type which depends on the kind of feed that we're trying to generate, since
         * probably not all kinds of feeds need text/xml. The MIME type for each template is loaded from the file
         * plugins/galleryfeeds/mimetypes.properties.php. If no matching mime type is found, 
         * text/xml will be used by default.
         *
         * @private
         */
        function _getMimeType( $feedType )
        {
            $types = new ConfigFileStorage( Array( "file" => PLOG_CLASS_PATH."plugins/galleryfeeds/mimetypes.properties.php" ));
            $mimeType = $types->getValue( $feedType );
            if( !$mimeType ) $mimeType = "text/xml";
            
            return( $mimeType );
        }
    
        /** 
         * This is the main method of an Action class and the one providing the 
         * business logic
         */
        function perform()
        {
            // load our view (a Smarty template)
            $this->_view = new PluginTemplatedView( $this->_blogInfo, 
                                                    "galleryfeeds",
                                                    $this->_feedType,
                                                    SMARTY_VIEW_CACHE_CHECK,
                                                    Array( "blogId" => $this->_blogInfo->getId(),
                                                           "albumId" => $this->_albumId,
                                                           "feedType" => $this->_feedType ));                                                                                                                                 
                                                           
            // tell the browser about the right content type            
            $this->_view->setContentType( $this->_getMimeType( $this->_feedType ));                                                                
            
            // nothing to do if the view is cached
            if( $this->_view->isCached())
                return true;        
        
            // load the albums by using the correct API method :)
            lt_include( PLOG_CLASS_PATH."class/gallery/dao/galleryresources.class.php" );
            lt_include( PLOG_CLASS_PATH."class/gallery/dao/galleryalbums.class.php" );            
            $galleryResources = new GalleryResources();
            $resources = $galleryResources->getUserResources( $this->_blogInfo->getId(),
                                                              $this->_albumId );
            // load the album too
            $galleryAlbums = new GalleryAlbums();
            $album = $galleryAlbums->getAlbum( $this->_albumId );

            // pass the resources to the template so that they can be rendered
            $this->_view->setValue( "resources", $resources );
            $this->_view->setValue( "album", $album );
            $this->setCommonData();
            
            return( true );
        }
    }
?>