<?php
lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
lt_include( PLOG_CLASS_PATH."plugins/gallery/class/view/plugingalleryconfigview.class.php" );

/**
 * This class is responsible for updating the gallery plugin settings. 
 *
 * @version 0.1
 * @author Laurent Vauthrin
 */
class PluginGalleryUpdateConfigAction extends AdminAction 
{  
    /**
     * @private
     */
    var $_pluginEnabled;
    var $_sidebarEnabled;
    var $_sidebarGreetingEnabled;
    var $_pathbarEnabled;
    var $_absolutePath; 
    var $_embedUri;
    var $_embedPath;
    var $_relativPath;
    var $_blocks;
    var $_show;
    var $_itemid;

    /**
     * Constructor.
     *
     * @param $actionInfo The action information.
     * @param $request The HTTP request information.
     * @return Returns the value passed back by AdminAction.
     */
    function PluginGalleryUpdateConfigAction( $actionInfo, $request ) 
    {
        $this->AdminAction( $actionInfo, $request );
    }

    /**
     * This function validates the form inputs.
     *
     * @param None.
     * @return Returns true.
     */
    function validate() 
    {
        $this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
        $this->_pluginEnabled = ( $this->_pluginEnabled != "" );

        $this->_sidebarEnabled = $this->_request->getValue( "sidebarEnabled" );
        $this->_sidebarEnabled = ( $this->_sidebarEnabled != "" );

        $this->_sidebarGreetingEnabled = $this->_request->getValue( "sidebarGreetingEnabled" );
        $this->_sidebarGreetingEnabled = ( $this->_sidebarGreetingEnabled != "" );

        $this->_pathbarEnabled = $this->_request->getValue( "pathbarEnabled" );
        $this->_pathbarEnabled = ( $this->_pathbarEnabled != "" ); 

	$this->_absolutePath = $this->_request->getValue( "absolutePath" );
	$this->_embedUri = $this->_request->getValue( "embedUri" );
	$this->_embedPath = $this->_request->getValue( "embedPath" );
	$this->_relativePath = $this->_request->getValue( "relativePath" );
	
	$this->_blocks = $this->_request->getValue( "blocks" );
	$this->_show = $this->_request->getValue( "show" );
	$this->_itemid = $this->_request->getValue( "itemid" );

        if ( $this->_embedUri == ""  || $this->_absolutePath == "" || 
	     $this->_embedPath == "" || $this->_relativePath == "" ) {
	    
	    $this->_view = new PluginGalleryConfigView( $this->_blogInfo );
            $this->_view->setErrorMessage( $this->_locale->tr( "error_required_missing" ) );
            $this->setCommonData();
	    
            return false;
        }

	// TODO: run checks to make sure that blocks and show have valid values

	if ( $this->_blocks == "specificItem"  && $this->_itemid == "" ) {
            $this->_view = new PluginGalleryConfigView( $this->_blogInfo );
	    $this->_view->setErrorMessage( $this->_locale->tr( "error_itemid" ) );
	    $this->setCommonData();
	    
	    return false;
	} 
	
	if ( $this->_blocks != "specificItem" ) {
	    //$this->_itemid = "";
	}

	if ( !file_exists( $this->_absolutePath ) ) {

	    $this->_view = new PluginGalleryConfigView( $this->_blogInfo );
            $this->_view->setErrorMessage( $this->_locale->tr( "error_absolute_path" ) );
            $this->setCommonData();

            return false;
	}

        return true;
    }

    /**
     * This function performs the action.
     *
     * @param None.
     * @return Returns true if the update was successful; otherwise returns false.
     */  
    function perform() 
    {
	// Get the blog settings
        $blogSettings = $this->_blogInfo->getSettings();

        // Update the relevant values with the form inputs
        $blogSettings->setValue( "plugin_gallery_enabled", $this->_pluginEnabled );
        $blogSettings->setValue( "gallery_sidebar_enabled", $this->_sidebarEnabled );
        $blogSettings->setValue( "gallery_sidebarGreeting_enabled", 
                                 $this->_sidebarGreetingEnabled );
        $blogSettings->setValue( "gallery_pathbar_enabled", $this->_pathbarEnabled );
	$blogSettings->setValue( "gallery_absolute_path", $this->_absolutePath );
	$blogSettings->setValue( "gallery_embed_uri", $this->_embedUri );
	$blogSettings->setValue( "gallery_embed_path", $this->_embedPath );
	$blogSettings->setValue( "gallery_relative_path", $this->_relativePath );
	$blogSettings->setValue( "gallery_blocks", $this->_blocks );
	$blogSettings->setValue( "gallery_show", $this->_show );
	$blogSettings->setValue( "gallery_itemid", $this->_itemid );

        // Set and save the new blog settings
        $this->_blogInfo->setSettings( $blogSettings );    
        $blogs = new Blogs();

	// Display an error message if there was a problem with the update
        if( !$blogs->updateBlog( $this->_blogInfo ) ) {
            $this->_view = new PluginGalleryConfigView( $this->_blogInfo );
            $this->_view->setErrorMessage( $this->_locale->tr( "error_updating_settings" ) );
            $this->setCommonData();
      
            return false;
        }
    
        // If things went well, save the session...
        $this->_blogInfo->setSettings( $blogSettings );
        $this->_session->setValue( "blogInfo", $this->_blogInfo );
        $this->saveSession();

        // and show the success message
        $this->_view = new PluginGalleryConfigView( $this->_blogInfo );
        $this->_view->setSuccessMessage( $this->_locale->tr( "gallery_settings_saved_ok" ) );
        $this->setCommonData();

        // clear the cache
        CacheControl::resetBlogCache( $this->_blogInfo->getId() );

        return true;
    }
}
?>
