<?php

lt_include(PLOG_CLASS_PATH.'class/plugin/pluginbase.class.php');

class PluginEmbedMedia extends PluginBase
{
    var $pluginEnabled;
    var $SRC;
    var $Auto;
    var $Loop;
    var $MusicName;
    var $Vol;
    var $Width;
    var $Height;
    var $Hidden;

    function PluginEmbedMedia($source = "")
    {
        $this->PluginBase($source);
        $this->id = 'embedmedia';
        $this->author = 'Marco Yan';
        $this->desc = "This plugin offers features to support Media Embed.";
        $this->version = '1.0';
        $this->locales = array('en_UK', 'zh_TW');
	if ($source == "admin")
            $this->initAdmin();
    }

    function initAdmin()
    {
        $this->registerAdminAction('embedmedia', 'PluginEmbedMediaConfigAction');
        $this->registerAdminAction('updateembedmedia', 'PluginEmbedMediaUpdateConfigAction');
        $menu =& Menu::getMenu();
        $this->addMenuEntry('/menu/controlCenter/manageSettings', 'EmbedMedia', '?op=embedmedia');
    }

    function register()
	{
        $blogSettings = $this->blogInfo->getSettings();
        $this->pluginEnabled = $blogSettings->getValue('plugin_embedmedia_enabled');

        $this->SRC = $blogSettings->getValue('plugin_embedmedia_SRC');
        $this->Auto = $blogSettings->getValue('plugin_embedmedia_Auto');
        $this->Loop = $blogSettings->getValue('plugin_embedmedia_Loop');
        $this->MusicName = $blogSettings->getValue('plugin_embedmedia_MusicName');
        $this->Vol = $blogSettings->getValue('plugin_embedmedia_Vol');
        $this->Width = $blogSettings->getValue('plugin_embedmedia_Width');
        $this->Height = $blogSettings->getValue('plugin_embedmedia_Height');
        $this->Hidden = $blogSettings->getValue('plugin_embedmedia_Hidden');

    }

    function isEnabled()
    {
        return $this->pluginEnabled;
    }
    
    // content
    function getSRC()
    {
        return $this->SRC;
    }

    function getAuto()
    {
        return $this->Auto;
    }

    function getLoop()
    {
        return $this->Loop;
    }

    function getMusicName()
    {
        return $this->MusicName;
    }

    function getVol()
    {
        return $this->Vol;
    }

    // suggestion
    function getWidth()
    {
        return $this->Width;
    }

    function getHeight()
    {
        return $this->Height;
    }

    function getHidden()
    {
        return $this->Hidden;
    }

}

?>
