<?php

lt_include(PLOG_CLASS_PATH.'class/action/admin/adminaction.class.php');
lt_include(PLOG_CLASS_PATH.'class/view/admin/adminplugintemplatedview.class.php');
lt_include(PLOG_CLASS_PATH.'plugins/embedmedia/class/view/pluginembedmediaconfigview.class.php');

// updates the plugin configuration
class PluginEmbedMediaUpdateConfigAction extends AdminAction
{
    var $_pluginEnabled;
    var $_SRC;
    var $_Auto;
    var $_Loop;
    var $_MusicName;
    var $_Vol;
    var $_Width;
    var $_Height;
    var $_Hidden;

	function PluginStickyPostsUpdateConfigAction($actionInfo, $request)
	{
		$this->AdminAction($actionInfo, $request);
	}

	function validate()
	{
        $errorMessages = array();
		$this->_pluginEnabled = $this->_request->getValue('pluginEnabled');
        $this->_pluginEnabled = ($this->_pluginEnabled != '');

		$this->_SRC = $this->_request->getValue('SRC');
		if ($this->_pluginEnabled && empty($this->_SRC)) {
            $errorMessages[] = 'embedmedia_error_SRC';
			$isError = true;
		}

		$this->_Auto = $this->_request->getValue('Auto');
		$this->_Loop = $this->_request->getValue('Loop');
		$this->_MusicName = $this->_request->getValue('MusicName');
		$this->_Vol = $this->_request->getValue('Vol');
		$this->_Width = $this->_request->getValue('Width');
		$this->_Height = $this->_request->getValue('Height');
		$this->_Hidden = $this->_request->getValue('Hidden');

		if (count($errorMessages) > 0) {
            $this->_view = new PluginEmbedMediaConfigView($this->_blogInfo);
			$allerror='';
			foreach ($errorMessages as $error) {
				$allerror .= $this->_locale->tr($error).'<br />';
			}
            $this->_view->setErrorMessage($this->_locale->tr($allerror));
            $this->setCommonData();
            return false;
        }

        return true;
    }

	function perform()
	{
        // // update the plugin configurations to blog setting
		$blogSettings = $this->_blogInfo->getSettings();
        $blogSettings->setValue('plugin_embedmedia_enabled', $this->_pluginEnabled);
        $blogSettings->setValue('plugin_embedmedia_SRC', $this->_SRC);
        $blogSettings->setValue('plugin_embedmedia_Auto', $this->_Auto);
        $blogSettings->setValue('plugin_embedmedia_Loop', $this->_Loop);
        $blogSettings->setValue('plugin_embedmedia_MusicName', $this->_MusicName);
        $blogSettings->setValue('plugin_embedmedia_Vol', $this->_Vol);
        $blogSettings->setValue('plugin_embedmedia_Width', $this->_Width);
        $blogSettings->setValue('plugin_embedmedia_Height', $this->_Height);
        $blogSettings->setValue('plugin_embedmedia_Hidden', $this->_Hidden);
        $this->_blogInfo->setSettings($blogSettings);

        // save the blogs settings
		$blogs = new Blogs();
        if (!$blogs->updateBlog($this->_blogInfo)) {
            $this->_view = new PluginStickyPostsConfigView($this->_blogInfo);
            $this->_view->setErrorMessage($this->_locale->tr('error_updating_settings'));
            $this->setCommonData();
            return false;
        }

		// if everything went ok...
        $this->_blogInfo->setSettings($blogSettings);
        $this->_session->setValue('blogInfo', $this->_blogInfo);
        $this->saveSession();

		$this->_view = new PluginEmbedMediaConfigView($this->_blogInfo);
		$this->_view->setSuccessMessage($this->_locale->tr('embedmedia_settings_saved_ok'));
		$this->setCommonData();

		// clear the cache
		CacheControl::resetBlogCache($this->_blogInfo->getId());

        return true;
	}
}

?>
