<?php

lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
lt_include( PLOG_CLASS_PATH."class/data/validator/stringvalidator.class.php" );
lt_include( PLOG_CLASS_PATH."class/data/validator/emailvalidator.class.php" );
lt_include( PLOG_CLASS_PATH."class/data/validator/httpurlvalidator.class.php" );
lt_include( PLOG_CLASS_PATH."class/data/validator/usernamevalidator.class.php" );
lt_include( PLOG_CLASS_PATH."plugins/editcomments/class/view/adminedittrackbackview.class.php" );
lt_include( PLOG_CLASS_PATH."class/view/admin/adminarticletrackbackslistview.class.php" );
lt_include( PLOG_CLASS_PATH."class/view/admin/adminpostslistview.class.php" );

class AdminUpdateTrackbackAction extends AdminAction {
    var $_trackbackId;
    var $_articleId;
	var $_op;
    var $_authorEmail;
    var $_authorUrl;
    var $_authorName;
    var $_commentText;
    var $_commentTopic;
    var $_commentNormalizedText;
    var $_commentNormalizedTopic;
    var $_commentStatus;
    var $_commentDateTime;
    var $_commentIp;
    
    function AdminUpdateTrackbackAction($actionInfo, $request){
        $this->AdminAction($actionInfo, $request);

        $this->_op = $actionInfo->getActionParamValue();
        if($this->_request->getValue("cancel")){
            $this->_op = "cancel";
        }

            // articleId is needed, even on a cancel operation
        $this->registerFieldValidator("articleId", new IntegerValidator());
        $this->_articleId = $this->_request->getValue( "articleId" );

        if($this->_op == "updateTrackback"){
            $view = new AdminEditTrackbackView($this->_blogInfo);

            $this->registerFieldValidator("trackbackId", new IntegerValidator());
            $this->registerFieldValidator("commentText", new StringValidator());
            $this->registerFieldValidator("authorName", new StringValidator());
            $this->registerFieldValidator("commentStatus", new IntegerValidator());
            $this->registerFieldValidator("commentTopic", new StringValidator(), true);
            $this->registerFieldValidator("authorEmail", new EmailValidator(), true);
            $this->registerFieldValidator("authorUrl", new HttpUrlValidator(), true);
                // no validation...
            $this->registerField("commentDateTime");
            $this->registerField("commentIp");
            
            $view->setErrorMessage( $this->_locale->tr("invalid_data"));
            $this->setValidationErrorView( $view );
            $this->_fetchFields();
        }
    }
    

    function _fetchFields(){
        lt_include( PLOG_CLASS_PATH."class/data/textfilter.class.php" );
        $this->_trackbackId = $this->_request->getValue("trackbackId");

        $this->_authorEmail = Textfilter::filterAllHTML($this->_request->getValue( "authorEmail" ));
        $this->_authorUrl   = Textfilter::filterAllHTML($this->_request->getValue( "authorUrl" ));
        if( (strlen($this->_authorUrl) != 0) &&
            ereg('^https?://',$this->_authorUrl) == false)
        {
            $this->_authorUrl = "http://".$this->_authorUrl;
        }
        $this->_authorName  = Textfilter::filterAllHTML($this->_request->getValue( "authorName" ));
        $this->_commentText = trim($this->_request->getValue( "commentText" ));
        $this->_commentTopic = Textfilter::filterAllHTML($this->_request->getValue( "commentTopic" ));
        $this->_commentStatus = $this->_request->getValue("commentStatus");
        $this->_commentIp = $this->_request->getValue("commentIp");
        $this->_commentNormalizedTopic = Textfilter::normalizeText($this->_commentTopic);
        $this->_commentNormalizedText = Textfilter::normalizeText($this->_commentText);
        
        $this->_commentDateTime = $this->_fetchCommentDateInformation();
    }

        // copied from AdminPostManagementCommon class
    function _fetchCommentDateInformation(){
        $commentDateTime = $this->_request->getValue("commentDateTime");
        $dateTimeParts = explode(" ", $commentDateTime);
        $dateParts = explode("/", $dateTimeParts[0] );
        $timeParts = explode(":",$dateTimeParts[1] );
        
        $postTimestamp = new Timestamp();
        $postTimestamp->setMinutes($timeParts[1]);
        $postTimestamp->setHour($timeParts[0]);
        $postTimestamp->setDay($dateParts[0]);
        $postTimestamp->setMonth($dateParts[1]);
        $postTimestamp->setYear($dateParts[2]);

        return $postTimestamp->getTimestamp();
    }

    
    function perform(){
        if($this->_op == "updateTrackback"){
            $trackbacks = new Trackbacks();
            $trackback = $trackbacks->getTrackback($this->_trackbackId);

            if(!$trackback){
                $this->_view = new AdminEditTrackbackView($this->_blogInfo, $id);
                $this->_view->setErrorMessage( $this->_locale->tr("pluginEditTrackbacksFailed") );
            }
            else if(!ArticleCommentStatus::isValidStatus($this->_commentStatus)){
                $this->_view = new AdminEditTrackbackView($this->_blogInfo, $id);
                $this->_view->setErrorMessage( $this->_locale->tr("pluginEditTrackbacksFailed") );
            }
            else{
                $trackback->setTopic($this->_commentTopic);
                $trackback->setText($this->_commentText);
                $trackback->setUserName($this->_authorName);
                $trackback->setUserEmail($this->_authorEmail);
                $trackback->setUserUrl($this->_authorUrl);
                $trackback->setDate($this->_commentDateTime);
                $trackback->setStatus($this->_commentStatus);
                $trackback->setClientIp($this->_commentIp);
                $trackback->setNormalizedTopic($this->_commentNormalizedTopic);
                $trackback->setNormalizedText($this->_commentNormalizedText);
 
                if($trackbacks->updateComment($trackback)) {
                    if($this->_articleId) {
                        $articles = new Articles();
                        $article = $articles->getBlogArticle($this->_articleId,
                                                             $this->_blogInfo->getId());
                        $this->_view = new AdminArticleTrackbacksListView(
                            $this->_blogInfo,
                            array("article" => $article));
                    }
                    else {
                        $this->_view = new AdminPostsListView( $this->_blogInfo );
                    }
                    $this->_view->setSuccessMessage( $this->_locale->tr("pluginEditTrackbacksOk") );
                    CacheControl::resetBlogCache( $this->_blogInfo->getId());
                }
                else {
                    $this->_view = new AdminArticleTrackbacksListView ($this->_blogInfo);
                    $this->_view->setErrorMessage( $this->_locale->tr("pluginEditTrackbacksFailed") );
                }
            }
        }
        else if($this->_articleId){
            $articles = new Articles();
            $article = $articles->getBlogArticle( $this->_articleId, $this->_blogInfo->getId());
            
            $this->_view = new AdminArticleTrackbacksListView(
                $this->_blogInfo,
                array("article" => $article));
            $this->_view->setSuccessMessage( $this->_locale->tr("pluginEditTrackbacksCancelled") );
        }
        else{
            $this->_view = new AdminPostsListView($this->_blogInfo);
        }

        $this->setCommonData();
    }
}
?>