<?php

lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
lt_include( PLOG_CLASS_PATH."class/data/validator/stringvalidator.class.php" );
lt_include( PLOG_CLASS_PATH."class/data/validator/emailvalidator.class.php" );
lt_include( PLOG_CLASS_PATH."class/data/validator/httpurlvalidator.class.php" );
lt_include( PLOG_CLASS_PATH."class/data/validator/usernamevalidator.class.php" );
lt_include( PLOG_CLASS_PATH."class/view/admin/adminarticlecommentslistview.class.php" );
lt_include( PLOG_CLASS_PATH."plugins/editcomments/class/view/admineditcommentview.class.php" );
lt_include( PLOG_CLASS_PATH."class/view/admin/adminpostslistview.class.php" );

class AdminUpdateCommentAction extends AdminAction{
    var $_commentId;
    var $_articleId;
	var $_op;
    var $_authorEmail;
    var $_authorUrl;
    var $_authorName;
    var $_commentText;
    var $_commentTopic;
    var $_commentNormalizedText;
    var $_commentNormalizedTopic;
    var $_commentStatus;
    var $_commentDateTime;
    var $_commentIp;
    
    function AdminUpdateCommentAction($actionInfo, $request){
        $this->AdminAction($actionInfo, $request);

        $this->_op = $actionInfo->getActionParamValue();
        if($this->_request->getValue("cancel")){
            $this->_op = "cancel";
        }

            // articleId is needed, even on a cancel operation
        $this->registerFieldValidator("articleId", new IntegerValidator());
        $this->_articleId = $this->_request->getValue( "articleId" );

        if($this->_op == "updateComment"){
            $view = new AdminEditCommentView($this->_blogInfo);

            $this->registerFieldValidator("commentId", new IntegerValidator());
            $this->registerFieldValidator("commentText", new StringValidator());
            $this->registerFieldValidator("authorName", new StringValidator());
            $this->registerFieldValidator("commentStatus", new IntegerValidator());
            $this->registerFieldValidator("commentTopic", new StringValidator(), true);
            $this->registerFieldValidator("authorEmail", new EmailValidator(), true);
            $this->registerFieldValidator("authorUrl", new HttpUrlValidator(), true);
                // no validation...
            $this->registerField("commentDateTime");
            $this->registerField("commentIp");
            
            $view->setErrorMessage( $this->_locale->tr("invalid_data"));
            $this->setValidationErrorView( $view );
            $this->_fetchFields();
        }
    }
    

    function _fetchFields(){
        lt_include( PLOG_CLASS_PATH."class/data/textfilter.class.php" );
        $this->_commentId = $this->_request->getValue("commentId");
            // TODO, be able to change parent?  drop down list?
            //$this->_parentId  = $this->_request->getValue( "parentId" );
            //if( $this->_parentId == null || $this->_parentId == "" )
            //$this->_parentId = 0;
        $this->_authorEmail = Textfilter::filterAllHTML($this->_request->getValue( "authorEmail" ));
        $this->_authorUrl   = Textfilter::filterAllHTML($this->_request->getValue( "authorUrl" ));
        if( (strlen($this->_authorUrl) != 0) &&
            ereg('^https?://',$this->_authorUrl) == false)
        {
            $this->_authorUrl = "http://".$this->_authorUrl;
        }
        $this->_authorName  = Textfilter::filterAllHTML($this->_request->getValue( "authorName" ));
        $this->_commentText = trim($this->_request->getValue( "commentText" ));
        $this->_commentTopic = Textfilter::filterAllHTML($this->_request->getValue( "commentTopic" ));
        $this->_commentStatus = $this->_request->getValue("commentStatus");
        $this->_commentIp = $this->_request->getValue("commentIp");
        $this->_commentNormalizedTopic = Textfilter::normalizeText($this->_commentTopic);
        $this->_commentNormalizedText = Textfilter::normalizeText($this->_commentText);
        
        $this->_commentDateTime = $this->_fetchCommentDateInformation();
    }

        // copied from AdminPostManagementCommon class
    function _fetchCommentDateInformation(){
        $commentDateTime = $this->_request->getValue("commentDateTime");
        $dateTimeParts = explode(" ", $commentDateTime);
        $dateParts = explode("/", $dateTimeParts[0] );
        $timeParts = explode(":",$dateTimeParts[1] );
        
        $postTimestamp = new Timestamp();
        $postTimestamp->setMinutes($timeParts[1]);
        $postTimestamp->setHour($timeParts[0]);
        $postTimestamp->setDay($dateParts[0]);
        $postTimestamp->setMonth($dateParts[1]);
        $postTimestamp->setYear($dateParts[2]);

        return $postTimestamp->getTimestamp();
    }

    
    function perform(){
        if($this->_op == "updateComment"){
            $comments = new ArticleComments();
            $comment = $comments->getComment($this->_commentId);
            if(!$comment){
                $this->_view = new AdminEditCommentView($this->_blogInfo, $id);
                $this->_view->setErrorMessage( $this->_locale->tr("pluginEditCommentsFailed") );
            }
            else if(!ArticleCommentStatus::isValidStatus($this->_commentStatus)){
                $this->_view = new AdminEditCommentView($this->_blogInfo, $id);
                $this->_view->setErrorMessage( $this->_locale->tr("pluginEditCommentsFailed") );
            }
            else{
                $comment->setTopic($this->_commentTopic);
                $comment->setText($this->_commentText);
                $comment->setUserName($this->_authorName);
                $comment->setUserEmail($this->_authorEmail);
                $comment->setUserUrl($this->_authorUrl);
                $comment->setDate($this->_commentDateTime);
                $comment->setStatus($this->_commentStatus);
                $comment->setClientIp($this->_commentIp);
                $comment->setNormalizedTopic($this->_commentNormalizedTopic);
                $comment->setNormalizedText($this->_commentNormalizedText);
                
                if($comments->updateComment($comment)){
                    if($this->_articleId){
                        $articles = new Articles();
                        $article = $articles->getBlogArticle($this->_articleId,
                                                             $this->_blogInfo->getId());
                        $this->_view = new AdminArticleCommentsListView(
                            $this->_blogInfo,
                            array("article" => $article));
                    }
                    else{
                        $this->_view = new AdminPostsListView( $this->_blogInfo );
                    }
                    $this->_view->setSuccessMessage( $this->_locale->tr("pluginEditCommentsOk") );
                    CacheControl::resetBlogCache( $this->_blogInfo->getId());
                }
                else{
                    $this->_view = new AdminArticleCommentsListView(
                        $this->_blogInfo);
                    $this->_view->setErrorMessage( $this->_locale->tr("pluginEditCommentsFailed") );
                }
            }
        }
        else if($this->_articleId){
            $articles = new Articles();
            $article = $articles->getBlogArticle( $this->_articleId, $this->_blogInfo->getId());
            
            $this->_view = new AdminArticleCommentsListView(
                $this->_blogInfo,
                array("article" => $article));
            $this->_view->setSuccessMessage( $this->_locale->tr("pluginEditCommentsCancelled") );
        }
        else{
            $this->_view = new AdminPostsListView($this->_blogInfo);
        }

        $this->setCommonData();
    }
}
?>