<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
    lt_include( PLOG_CLASS_PATH."plugins/cssnaked/class/view/admincssnakedconfigview.class.php" );

    class AdminCssNakedConfigUpdateAction extends AdminAction 
	{
	
        var $_pluginEnabled;
        var $_startDate;
        var $_endDate;
        var $_addNotice;
        
    	/**
         * Constructor. If nothing else, it also has to call the constructor of the parent
         * class, BlogAction with the same parameters
         */
        function AdminCssNakedConfigUpdateAction( $actionInfo, $request )
        {
        	$this->AdminAction( $actionInfo, $request );
        }
		
		function validate()
		{

            $this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
            $this->_pluginEnabled = ($this->_pluginEnabled != "" );	
            
            $this->_addNotice = $this->_request->getValue( "addNotice" );
            $this->_addNotice = ($this->_addNotice != "" );	
            
            if ( ( $this->_startDate = strtotime($this->_request->getValue("startDate")) ) === false ) {
            
                $this->_view = new AdminCssNakedConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("cssnaked_error_startDate")); 
                $this->setCommonData();
                return false;
            }
            
            if ( ( $this->_endDate = strtotime($this->_request->getValue("endDate")) ) === false) {
                $this->_view = new AdminCssNakedConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("cssnaked_error_endDate")); 
                $this->setCommonData();
            	return false;
			}

			return true;
		}
		
        /**
         * Carries out the specified action
         */
        function perform()
        {

            // update the plugin configurations to blog setting
			$blogSettings = $this->_blogInfo->getSettings();
            $blogSettings->setValue( "plugin_cssnaked_enabled", $this->_pluginEnabled );
            $blogSettings->setValue( "plugin_cssnaked_startDate", $this->_startDate );
            $blogSettings->setValue( "plugin_cssnaked_endDate", $this->_endDate );
            $blogSettings->setValue( "plugin_cssnaked_addNotice", $this->_addNotice );
            
            //TODO
            //$blogSettings->setValue( "plugin_cssnaked_timeFrame",  );

	
			// save the blogs settings
			$blogs = new Blogs();
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new AdminCssNakedConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();
                
                return false;                       
            }
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();
			
			$this->_view = new AdminCssNakedConfigView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("cssnaked_settings_saved_ok"));			
			$this->setCommonData();
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());					
            
            return true;		
        }
    }
?>
