<?php

	lt_include( PLOG_CLASS_PATH."class/dao/model.class.php" );
    lt_include( PLOG_CLASS_PATH."plugins/contentfilter/class/dao/filteredcontent.class.php" );
    
    /**
     * ids of the caches being used
     */
    define( "CACHE_FILTERED_CONTENT", "cache_filtered_content" );
    define( "CACHE_FILTERED_CONTENT_BYBLOG", "cache_filtered_content_byblog" );

    /**
     * Takes care of dealing with fetching filtered contents from the database
     */
	class FilteredContents extends Model 
	{

    	function FilteredContents()
        {
        	$this->Model();
        	$this->table = $this->getPrefix()."filtered_content";
        }

        /**
         * Returns the content that should be filtered, but only the content that
         * has been set up by this blog.
         *
         * @param blogId The blog
         * @param includeGlobal Whether to return globally-filtered content or not
         * @return An array filled with FilteredContent objects, or an empty array if
         * none was found
         */
        function getBlogFilteredContents( $blogId, $includeGlobal = false )
        {
            $data = $this->getMany( "blog_id", $blogId, CACHE_FILTERED_CONTENT_BYBLOG );
            if( !$data )
                $data = Array();

            if( $includeGlobal )
                $data = array_merge( $data, $this->getBlogFilteredContents( "0", false ));
                
            return( $data );
        }

        /**
         * Returns only one rule belonging to the blog
         */
        function getBlogFilteredContent( $ruleId, $blogId )
        {
            $rule = $this->get( "id", $ruleId, CACHE_FILTERED_CONTENT );
            if( !$rule )
                return false;
                
            if( $rule->getBlogId() == $blogId )
                return( $rule );
            else
                return( false );
        }

        /**
         * Returns the content that should be filtered, but only the content that
         * has been set up by the administrator(s) of the site
         *
         * @return An array filled with FilteredContent objects, or an empty array if
         * none was found
         */
        function getGlobalFilteredContents()
        {
            return( $this->getBlogFilteredContents( "0" ));
        }

        /**
         * Adds a new rule to filter content.
         *
		 * @param filteredContent A FilteredContent object
         * @return Returns true if added successfully or false otherwise.
         */
        function addBlogFilteredContent( $filteredContent )
        {
            if(( $result = parent::add( $filteredContent ))) {
                $this->_cache->removeData( $filteredContent->getBlogId(), CACHE_FILTERED_CONTENT_BYBLOG );
            }
            
            return( $result );
        }

        /**
         * Adds a new global rule
         *
         * @param regExp The regular expression we'd like to add
         * @param reason The reason why we'd like to add such rule
         * @return Returns true if added successfully or false otherwise.
         */
        function addGlobalFilteredContent( $regExp, $reason = "" )
        {
        	return $this->addBlogFilteredContent( $regExp, 0, $reason );
        }

        /**
         * Removes a rule from the database
         *
         * @param ruleId The rule we'd like to delete
         * @param blogId The blog to which this rule belogs
         * @return Returns true upon success or false otherwise
         */
        function removeBlogFilteredContent( $ruleId, $blogId )
        {
            $rule = $this->getBlogFilteredContent( $ruleId, $blogId );
            if( !$rule )
                return false;
                
            if(( $result = $this->delete( "id", $ruleId ))) {
                $this->_cache->removeData( $ruleId, CACHE_FILTERED_CONTENT );
                $this->_cache->removeData( $blogId, CACHE_FILTERED_CONTENT_BYBLOG );
            }

            return $result;
        }

        /**
         * Removes a global rule
         *
         * @param ruleId The id of the rule we'd like to delete
         * @return Returns true upon success or false otherwise
         */
        function removeGlobalFilteredContent( $ruleId )
        {
        	return $this->removeBlogFilteredContent( $ruleId, 0 );
        }

        /**
         * updates a rule
         *
         * @param rule a FilteredContent object containing the data
         * we'd like to update.
         * @return True upon success or false otherwise.
         */
        function updateFilteredContent( $rule )
        {
            if(( $result = parent::update( $rule ))) {
                $this->_cache->removeData( $rule->getId(), CACHE_FILTERED_CONTENT );
                $this->_cache->removeData( $rule->getBlogId(), CACHE_FILTERED_CONTENT_BYBLOG );
            }
            
            return( $result );
        }

        /**
         * @private
         * Maps a row from the database to its object
         */
        function mapRow( $row )
        {
        	$filteredContent = new FilteredContent( $row["reg_exp"], 
        	                                        $row["blog_id"],
                                                    $row["reason"], 
                                                    $row["date"],
                                                    $row["id"] );

            return $filteredContent;
        }
    }
?>
