<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/closecomments/class/view/adminclosecommentssettingsview.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/blogs.class.php" );
	lt_include( PLOG_CLASS_PATH."class/template/cachecontrol.class.php" );	

	class AdminUpdateCloseCommentsSettingsAction extends AdminAction
	{
		function AdminUpdateCloseCommentsSettingsAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );
			
			$this->registerField( "pluginEnabled" );
			$this->registerFieldValidator( "period", new IntegerValidator(), true );
			$view = new AdminCloseCommentsSettingsView( $this->_blogInfo );
			$view->setErrorMessage( $this->_locale->tr("error_updating_closecomments_settings" ));
			$this->setValidationErrorView( $view );
			
			$this->requirePermission( "manage_plugins" );
		}
		
		function perform()
		{						
			$pluginEnabled = $this->_request->getValue( "pluginEnabled" );
			$period = $this->_request->getValue( "period" );
			
			$blogSettings = $this->_blogInfo->getSettings();
            $blogSettings->setValue( "plugin_closecomments_enabled", $pluginEnabled );
            $blogSettings->setValue( "plugin_closecomments_period", $period );
            $this->_blogInfo->setSettings( $blogSettings );
			
			// save the blogs settings
			$blogs = new Blogs();
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new AdminCloseCommentsSettingsView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_closecomments_settings"));
                $this->setCommonData();

                return false;
            }

			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();

			$this->_view = new AdminCloseCommentsSettingsView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("closecomment_settings_saved_ok"));
			$this->setCommonData();
			
			CacheControl::resetBlogCache( $this->_blogInfo->getId());
			
			return( true );
		}
	}
?>