<?php

    lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
    
    class PluginClickableComments extends PluginBase
    {
    
        function PluginClickableComments($source = "")
        {
            $this->PluginBase($source);
            
            $this->id = "clickablecomments";
            $this->desc = "Converts URLs in comments left by visitors into clickable links";
            $this->author = "The LifeType Project";            
            $this->version = "20070708";

            if($source != "admin")
				$this->init();
        }

        function init(){
            // that's the only event we care for!
            $this->registerNotification( EVENT_PRE_COMMENT_ADD );            
        }
        
        function process( $eventType, $params )
        {
            $comment = $params["comment"];
            $text = $comment->getText();
            $comment->setText( $this->linkurl( $text ));
            $params["comment"] = $comment;
            
            return( true );
        }        
    
    /*
     * @private
     * Modified from an Smarty plugin
     * -------------------------------------------------------------
     * File:     modifier.linkurl.php
     * Purpose:  links URLs und shortens it to $length
     *
     * Author:   Christoph Erdmann <smarty@cerdmann.com>
     * Internet: http://www.cerdmann.com
     *
     * Changelog:
     * 2004-11-24 New parameter allows truncation without linking the URL
     * 2004-11-20 In braces enclosed URLs are now better recognized
     * -------------------------------------------------------------
     */
    function linkurl($string, $length=50, $link=true)
        {
        if (!function_exists(kuerzen)) {
        function kuerzen($string,$length)
            {
            $returner = $string;
            if (strlen($returner) > $length)
                {
                $url = preg_match("=[^/]/[^/]=",$returner,$treffer,PREG_OFFSET_CAPTURE);
                $cutpos = $treffer[0][1]+2;
                $part[0] = substr($returner,0,$cutpos);
                $part[1] = substr($returner,$cutpos);
    
                $strlen1 = $cutpos;
                if ($strlen1 > $length) return substr($returner,0,$length-3).'...';
                $strlen2 = strlen($part[1]);
                $cutpos = $strlen2-($length-3-$strlen1);
                $returner = $part[0].'...'.substr($part[1],$cutpos);
                }
            return $returner;
            }
        }
    
        if ($link == true)
            {
            $pattern = '#(^|[^\"=]{1})(http://|ftp://|mailto:|news:)([^\s<>\)]+)([\s\n<>\)]|$)#sme';
            $string = preg_replace($pattern,"'$1<a href=\"$2$3\" title=\"$2$3\" target=\"_blank\">'.kuerzen('$2$3',$length).'</a>$4'",$string);
            }
        elseif ($link == false)
            {
            $pattern = '#(^|[^\"=]{1})(http://|ftp://|mailto:|news:)([^\s<>\)]+)([\s\n<>\)]|$)#sme';
            $string = preg_replace($pattern,"kuerzen('$2$3',$length)",$string);
            }
    
        return $string;	
        }       
    }
?>