<?php
 
lt_include( PLOG_CLASS_PATH."class/plugin/pluginbase.class.php" );
lt_include( PLOG_CLASS_PATH."class/dao/articles.class.php" );
lt_include( PLOG_CLASS_PATH."class/dao/article.class.php" );
lt_include( PLOG_CLASS_PATH."class/database/db.class.php" );
    
    /*
     * Plugin that offers features to return links to the next and previous articles
     * within the current category
     */
class PluginCategoryBrowser extends PluginBase
{
	var $_articles;
    var $_prefix;
	
    function PluginCategoryBrowser($source = ""){
        $this->PluginBase($source);

	    $this->id = "categorybrowser";
        $this->version = "20070302";
        $this->author = "Jon Daley";
        $this->desc = "This plugin adds the ability to have next
	            and previous buttons that stay within the same category as the
		    current post<br/>Usage:<br/>Functions:<br/>
		    getPrevArticle(currArticle, blogId)<br/>
		    getNextArticle(currArticle, blogId)<br/>
		    getFirstArticle(categoryId, blogId) and<br/>
		    getLastArticle(categoryId, blogId)<br/>
		    Given an article the Prev and Next functions will
		    return the previous and next posts in the same
		    category as the given article.<br/>
		    Given a category id, the First and Last functions
		    will return the first and last posts in the same
		    category.<br/>
		    They will return false if it doesn't exist, or an Article
                    object if it does.<br/>";

	    $this->db =& Db::getDb();
	    $this->_prefix =  Db::getPrefix();
	    $this->_articles = new Articles();
    }

    function getPrevArticle($article, $categoryId, $blogId){
            // gets the article that is just before this one in
            // the same category
        $query = "SELECT id FROM " . $this->_prefix . 
            "articles, " . $this->_prefix."article_categories_link l" .
            " WHERE date < '" . $article->getDate() . 
            "' AND status=1 AND blog_id = " . $blogId . 
            " AND l.category_id = " . $categoryId . 
            " and article_id = id" .
            " ORDER BY date DESC LIMIT 1;";
        
        $result = $this->db->Execute($query);
	    if(!$result || ($result->RecordCount() == 0))
            return false;

            // get the information from the article
        $row = $result->FetchRow();

            // fetch the article
	    return $this->_articles->getBlogArticle($row["id"], $blogId);
    }

    function getNextArticle($article, $categoryId, $blogId){
            // gets the article that is just after this one in
            // the same category
        $query = "SELECT id FROM " . $this->_prefix . 
            "articles, " . $this->_prefix."article_categories_link l" .
            " WHERE date > '" . $article->getDate() . 
            "' AND status=1 AND blog_id = " . $blogId . 
            " AND l.category_id = " . $categoryId . 
            " and article_id = id" .
            " ORDER BY date LIMIT 1;";
        $result = $this->db->Execute($query);
	    if(!$result || ($result->RecordCount() == 0)){
            return false;
        }

            // get the information from the article
        $row = $result->FetchRow();

            // fetch the article
	    return $this->_articles->getBlogArticle($row["id"], $blogId);
    }

    function getFirstArticle($categoryId, $blogId){
            // gets the first article in the category
        $query = "SELECT id FROM " . $this->_prefix . 
            "articles, " . $this->_prefix."article_categories_link l" .
            " WHERE status=1 AND blog_id = " . $blogId . 
            " AND l.category_id = " . $categoryId . 
            " and article_id = id" .
            " ORDER BY date LIMIT 1;";

        $result = $this->db->Execute($query);
	    if(!$result || ($result->RecordCount() == 0))
            return false;

            // get the information from the article
        $row = $result->FetchRow();

            // fetch the article
	    return $this->_articles->getBlogArticle($row["id"], $blogId);
    }

    function getLastArticle($categoryId, $blogId){
            // gets the last article in the category
        $query = "SELECT id FROM " . $this->_prefix . 
            "articles, " . $this->_prefix."article_categories_link l" .
            " WHERE status=1 AND blog_id = " . $blogId . 
            " AND l.category_id = " . $categoryId . 
            " and article_id = id" .
            " ORDER BY date DESC LIMIT 1;";

        $result = $this->db->Execute($query);
	    if(!$result || ($result->RecordCount() == 0))
            return false;

            // get the information from the article
        $row = $result->FetchRow();

            // fetch the article
	    return $this->_articles->getBlogArticle($row["id"], $blogId);
    }
}
        
        
?>
