<?php

	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/plogatomabstractservice.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/template/atomoutputrenderer.class.php" );	
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/net/atomrequestgenerator.class.php" );
	lt_include( PLOG_CLASS_PATH."class/dao/articlecategories.class.php" );
	
	/**
	 * implements the service.categories service
	 */
	class CategoriesService extends PlogAtomAbstractService 
	{
	
		function CategoriesService( $request )
		{
			$this->PlogAtomAbstractService( $request );
		}
		
		/**
		 * returns the list of categories in the current blog
		 */
		function doGet()
		{
			$output = new AtomOutputRenderer( "categories" );
			
			// load the categories from the db
			$categories = new ArticleCategories();
			$blogCategories = $categories->getBlogCategories( $this->_blogInfo->getId());

			$output->setValue( "blog", $this->_blogInfo );
			$output->setValue( "user", $this->_userInfo );
			$output->setValue( "url", new AtomRequestGenerator( $this->getBlogInfo()));
			$output->setValue( "categories", $blogCategories );
			
			// set the response
			$response = new AtomResponse( $output->fetch());
			$this->setResponse( $response );
			
			return true;
		}
	}
?>