<?php

	
	
	/**
	 * encapsulates an atom response
	 */
	class AtomResponse
	{
	
		var $_isError;
		var $_output;
		var $_headers;
		var $_contentType;
	
		function AtomResponse( $output = "" , $headers = Array())
		{
			
			
			// class attributes
			$this->_isError = false;
			$this->_output = $output;
			$this->_headers = $headers;
			$this->_contentType = ATOM_DEFAULT_CONTENT_TYPE;
		}
		
		/**
		 * output of the service, if any
		 *
		 * @return The string that will be returned to the client
		 */
		function getOutput()
		{
			return $this->_output;
		}
		
		/**
		 * returns the http headers that will be sent back to the client
		 *
		 * @return An array with strings that represent the headers that will be sent
		 * to the client.
		 */
		function getHeaders()
		{
			return $this->_headers;
		}
		
		/**
		 * content type that will be returned to the client
		 *
		 * @return An string representing a valid mime type
		 */
		function getContentType()
		{
			return ATOM_DEFAULT_CONTENT_TYPE;
		}
		
		/**
		 * whether the processing of this request caused an error or not
		 */
		function isError()
		{
			return $this->_isError;
		}
		
		/**
		 * whether the current request caused an error or not
		 *
		 * @param error True or false
		 */
		function setError( $error )
		{
			$this->_isError = $error;
		} 
	}
?>