<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/view/adminatompluginsettingsview.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/dao/atompasswords.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/atomconstants.properties.php" );

	class AdminAtomPluginUpdateSettingsAction extends AdminAction
	{
		var $_categoryId;
		var $_albumId;
		var $_password;
		var $_loggingEnabled;
		var $_dontSetHeaders;
		var $_previewType;

		function AdminAtomPluginUpdateSettingsAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );
			
			$this->requirePermission( "manage_plugins" );
		}
	
		function validate()
		{
			$this->_categoryId = $this->_request->getValue( "categoryId" );
			$this->_albumId = $this->_request->getValue( "albumId" );
			$this->_password = $this->_request->getValue( "password" );
			// check how images should be embedded
			$this->_previewType = $this->_request->getValue( "resourcePreviewType" );
			if( $this->_previewType < ATOM_EMBED_SMALL_PREVIEW ||
			    $this->_previewType > ATOM_EMBED_FULL_SIZE_VIEW )
			    $this->_previewType = ATOM_EMBED_SMALL_PREVIEW;
			
			$this->_loggingEnabled = $this->_request->getValue( "loggingEnabled" );
			$this->_dontSetHeaders = $this->_request->getValue( "dontSetHeaders" );
			if( $this->_loggingEnabled != 1 ) $this->_loggingEnabled = false;
			if( $this->_dontSetHeaders != 1 ) $this->_dontSetHeaders = false;

			return true;
		}

		function perform()
		{
			// save the settings
			$blogSettings = $this->_blogInfo->getSettings();
			$blogSettings->setValue( "plugin_atom_article_category_id", $this->_categoryId );
			$blogSettings->setValue( "plugin_atom_gallery_resource_album_id", $this->_albumId );
			$blogSettings->setValue( "plugin_atom_resource_preview_type", $this->_previewType );
			$this->_blogInfo->setSettings( $blogSettings );
			$blogs = new Blogs();
			// update the settings in the database *and* in the session, otherwise we will
			// keep using the old settings!!
			$blogs->updateBlog( $this->_blogInfo );
			$this->_session->setValue( "blogInfo", $this->_blogInfo );
			$this->saveSession();

			// and now, save the password
			$passwords = new AtomPasswords();
			$passwords->setPassword( $this->_userInfo->getId(), $this->_password );
			
			// if the user is an admin, we need to save a couple more things
			if( $this->_userInfo->isSiteAdmin()) {
			     $config =& Config::getConfig();
			     $config->setValue( "atom_dont_set_headers", $this->_dontSetHeaders );
			     $config->setValue( "atom_logging_enabled", $this->_loggingEnabled );
			     $config->save();
			     $config->reload();
			}

			// show an informative message
			$this->_view = new AdminAtomPluginSettingsView( $this->_blogInfo, $this->_userInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("atom_plugin_settings_saved_ok"));
			$this->setCommonData();
		
			return true;
		}
	}
?>