<?php

	/**
	 * atom entry point for plog
	 */
	 
    if (!defined( "PLOG_CLASS_PATH" )) {
        define( "PLOG_CLASS_PATH", dirname(__FILE__)."/");
    }

	include( PLOG_CLASS_PATH."class/bootstrap.php" );
    	 
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/xml/atom/atomserver.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/atom/class/logger/atomlogger.class.php" );
    lt_include( PLOG_CLASS_PATH."class/config/config.class.php" );
	
	// some of our settings are in the configuration
	$config =& Config::getConfig();	
	
	AtomLogger::Log( "** Starting **" );
	AtomLogger::Log( "   Request URI: ".$_SERVER["REQUEST_URI"] );
	
	// process the incoming request
	$server = new AtomServer();
	$server->processRequest( new AtomRequest());
	
	// get the response and send it back to the client
	$response = $server->getResponse();
	
	// this is not good so let's at least show something
	if( $response == null ) {
	   // sent the headers only if we are configured to do so
	   if( !$config->getValue( "atom_dont_set_headers" ))
		  header( "HTTP 500 Internal Server Error" );
		  
		die("Unexpected Atom exception");
	}
	
    // some servers don't like us messing around with headers so let's make it optional
	if( !$config->getValue( "atom_dont_set_headers" )) {
	// first send the headers and then the text of the response	
	   foreach( $response->getHeaders() as $header )
	       header( $header );
	       
	   // send the content type header
	   header( "Content-Type: ".$response->getContentType());
	}
	
	print( $response->getOutput());

	AtomLogger::Log( "   Response sent: ".$response->getOutput());
	AtomLogger::Log( "** End **" );
?>