<?php

    /*
    Copyright 2006 Paul Westbrook (paul@westbrooks.org)
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    */

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
    lt_include( PLOG_CLASS_PATH."plugins/akismet/class/view/pluginakismetconfigview.class.php" ); 

    $apiKeyValid = true;
    
    class PluginAkismetUpdateConfigAction extends AdminAction 
	{
	
		var $_pluginEnabled;
		var $_apiKey;


    	/**
         * Constructor. If nothing else, it also has to call the constructor of the parent
         * class, BlogAction with the same parameters
         */
        function PluginAkismetUpdateConfigAction( $actionInfo, $request )
        {
        	$this->AdminAction( $actionInfo, $request );
        }
		
		function validate()
		{
			global $apiKeyValid;
	   
        	$apiKeyValid = true;

            $this->_pluginEnabled = $this->_request->getValue( "pluginEnabled" );
            $this->_pluginEnabled = ($this->_pluginEnabled != "" );			
        
            $this->_apiKey = $this->_request->getValue( "apiKey" );
     
            if( $this->_pluginEnabled == true && $this->_apiKey == "" ) {
                $this->_view = new PluginAkismetConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("akismet_missing_api_key"));
                $this->setCommonData();

                return false;                
            }
            
            if( $this->_pluginEnabled == true )
            {
            
                $rg = $this->_blogInfo->getBlogRequestGenerator();

                // Check the API key to see if it is valid
                lt_include( PLOG_CLASS_PATH."plugins/akismet/class/security/Akismet.class.php" );
                set_error_handler('_akismetErrorHandler');
                $akismet = new Akismet($rg->blogLink(), $this->_apiKey);
                restore_error_handler();
                
                if ( $apiKeyValid == false )
                {
                    $this->_view = new PluginAkismetConfigView( $this->_blogInfo );
                    $this->_view->setErrorMessage( $this->_locale->tr("akismet_invalid_api_key"));
                    $this->setCommonData();
    
                    return false;                                
                }
            }

			return true;
		}
		
        /**
         * Carries out the specified action
         */
        function perform()
        {
            // update the plugin configurations to blog setting
			$blogSettings = $this->_blogInfo->getSettings();
            $blogSettings->setValue( "plugin_akismet_enabled", $this->_pluginEnabled );

            $blogSettings->setValue( "plugin_akismet_api_key", $this->_apiKey );

            $this->_blogInfo->setSettings( $blogSettings ); 
		
			// save the blogs settings
			$blogs = new Blogs();
            if( !$blogs->updateBlog( $this->_blogInfo )) {
                $this->_view = new PluginAkismetConfigView( $this->_blogInfo );
                $this->_view->setErrorMessage( $this->_locale->tr("error_updating_settings"));
                $this->setCommonData();

                return false;                       
            }
			
			// if everything went ok...
            $this->_blogInfo->setSettings( $blogSettings );
            $this->_session->setValue( "blogInfo", $this->_blogInfo );
            $this->saveSession();
			
			$this->_view = new PluginAkismetConfigView( $this->_blogInfo );
			$this->_view->setSuccessMessage( $this->_locale->tr("akismet_settings_saved_ok"));			
			$this->setCommonData();
			
			// clear the cache
			CacheControl::resetBlogCache( $this->_blogInfo->getId());					
            
            return true;		
        }
    }
    
    /**
	 * This error handler temporarily overloads the LifeType one
	 * occurs.
	 */
	function _akismetErrorHandler( $errorCode, $errorString )
	{
	   global $apiKeyValid;
	   
	   $apiKeyValid = false;
	}

?>
