<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminarticlecommentslistview.class.php" );
    lt_include( PLOG_CLASS_PATH."class/dao/articles.class.php" );	
    lt_include( PLOG_CLASS_PATH."class/dao/articlecomments.class.php" );
    lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/arrayvalidator.class.php" );

    /**
     * \ingroup Action
     * @private
     *
     * Action that shows a list of all the comments for a given post
     */
     
     $akismetError2 = false;

    class PluginAkismetSubmitCommentAction extends AdminAction 
	{

    	var $_articleId;
        var $_commentIds;

    	/**
         * Constructor. If nothing else, it also has to call the constructor of the parent
         * class, BlogAction with the same parameters
         */
        function PluginAkismetSubmitCommentAction( $actionInfo, $request )
        {
       	    $this->AdminAction( $actionInfo, $request );
			
			// data validation
			$this->registerFieldValidator( "commentId", new IntegerValidator());
//			$this->registerFieldValidator( "articleId", new IntegerValidator());
			$view = new AdminArticleCommentsListView( $this->_blogInfo );
			$view->setErrorMessage( $this->_locale->tr("akismet_error_submiting_comments"));
			$this->setValidationErrorView( $view );
			
			$this->requirePermission( "update_comment" );
        }
		
		/**
		 * sets up the parameters and calls the method below
		 */
		function perform()
		{
			$this->_articleId = $this->_request->getValue( "articleId" );

            // This may need to check a "mode" parameter if this plugin
            // ever allows submitting something not as spam.
            $commentId = $this->_request->getValue( "commentId" );
            $this->_commentIds = Array();
            $this->_commentIds[] = $commentId;
				
				
			$this->_submitComments();
			
			return true;
		}

        /**
         * deletes comments
		 * @private
         */
        function _submitComments()
        {
           global $akismetError2;

            $comments = new ArticleComments();
            $errorMessage = "";
			$successMessage = "";
			$totalOk = 0;
			
			if( $this->_articleId > 0 ) {
				// if we can't even load the article, then forget it...
				$articles = new Articles();
				$article = $articles->getBlogArticle( $this->_articleId, $this->_blogInfo->getId());
				if( !$article ) {
					$this->_view = new AdminArticleCommentsListView( $this->_blogInfo );
					$this->_view->setErrorMessage( $this->_locale->tr("error_fetching_article" ));
					$this->setCommonData();
					
					return false;
				}
			}
			else {
				// there was no article, so this probably was the view that shows all comments...
				$article = null;
			}
			
			// loop through the comments and remove them
            foreach( $this->_commentIds as $commentId ) {
            
            	// fetch the comment
				$comment = $comments->getComment( $commentId );
				
				if( !$comment ) {
					$errorMessage .= $this->_locale->pr("akismet_error_error_retrieving_comment", $commentId);
				}
				else {
				    // Send the information to Akismet.
                    $rg = $this->_blogInfo->getBlogRequestGenerator();
         
                    lt_include( PLOG_CLASS_PATH."plugins/akismet/class/security/Akismet.class.php" );
                    
                    $blogSettings = $this->_blogInfo->getSettings();

                    $apiKey = $blogSettings->getValue( "plugin_akismet_api_key" );
        
                    set_error_handler('_akismetFilterSubmitErrorHandler');
        
                    $akismet = new Akismet($rg->blogLink(), $apiKey);
                    
                    
                    if ( $akismetError2 == true ) {
                        restore_error_handler();
        
                        continue;
                    }
        
                    if ( $comment->getUserName() != "" )
                        $akismet->setAuthor($comment->getUserName());
        
                    if ( $comment->getUserEmail() != "" )
                        $akismet->setAuthorEmail($comment->getUserEmail());
                    $akismet->setAuthorURL($comment->getUserUrl());
                    $akismet->setContent($comment->getText());
                    $akismet->setType("comment");
         
                    lt_include( PLOG_CLASS_PATH."class/dao/article.class.php");
         
                    $commentArticle = $comment->getArticle();
        
                    $akismet->setPermalink( $rg->postPermalink($commentArticle) );
         
                    $akismet->submitSpam();

                    restore_error_handler();
                }
            }

			// if everything fine, then display the same view again with the feedback
			if( $this->_articleId == 0 )
				$this->_view = new AdminArticleCommentsListView( $this->_blogInfo, Array( "article" => null ));
			else
				$this->_view = new AdminArticleCommentsListView( $this->_blogInfo, Array( "article" => $article ));
				
            if ( $akismetError2 == true ) {
                $this->_view->setErrorMessage( $this->_locale->pr("akismet_failed_submit_spam") );
			} else {
				$this->_view->setSuccessMessage( $this->_locale->pr("akismet_sucess_submit_spam") );			
			}
            $this->setCommonData();

            // better to return true if everything fine
            return true;
        }
    }
    
            /**
	 * This error handler temporarily overloads the LifeType one
	 * occurs.
	 */
	function _akismetFilterSubmitErrorHandler( $errorCode, $errorString )
	{
	   global $akismetError2;
	   
	   $akismetError2 = true;
	}

?>