<?php

	lt_include( PLOG_CLASS_PATH."class/database/dbobject.class.php" );
	
	/**
	 * Where to show ads, values for the $mode parameter
	 */
	define( "PLUGIN_ADS_POSITION_TOP", 1 );
	define( "PLUGIN_ADS_POSITION_BOTTOM", 2 );
	define( "PLUGIN_ADS_POSITION_CUSTOM", 3 );		
	
	/**
	 * mode of operation (i.e. which blogs get to see ads?)
	 */
	define( "PLUGIN_ADS_BLOGS_SHOW_ALL", 1 );
	define( "PLUGIN_ADS_BLOGS_INCLUDE_LIST", 2 );		
	define( "PLUGIN_ADS_BLOGS_EXCLUDE_LIST", 3 );	

	/** 
	 * Object that represents each one of the ad blocks
	 */
	class AdBlock extends DbObject
	{
		var $_code;
		var $_pos;
		var $_name;
		var $_blogs;
		var $_mode;
		var $_id;
		
		function AdBlock()
		{
			$this->DbObject();
			
			$this->_pk = "id";
		
			$this->_fields = Array(
				"id" => "getId",
				"block_position" => "getPosition",
				"block_code" => "getCode",
				"block_name" => "getName",
				"block_blogs" => "getBlogs",
				"block_mode" => "getMode"
			);
		}
		
		function setId( $id )
		{
			$this->_id = $id;
		}
		
		function getId()
		{
			return( $this->_id );
		}
		
		function getCode()
		{
			return( $this->_code );
		}
		
		function setCode( $code )
		{
			$this->_code = $code;			
		}
		
		function getPosition()
		{
			return( $this->_pos );
		}
		
		function setPosition( $pos )
		{
			$this->_pos = $pos;
		}
		
		function getName()
		{
			return( $this->_name );
		}
		
		function setName( $name )
		{
			$this->_name = $name;
		}
		
		function setBlogs( $blogs )
		{
			$this->_blogs = $blogs;
		}
		
		function getBlogs()
		{
			if( !is_array( $this->_blogs ))
				$this->_blogs = Array();
				
			return( $this->_blogs );
		}
		
		function getBlogInfos()
		{
			lt_include( PLOG_CLASS_PATH."class/dao/blogs.class.php" );
			
			$blogInfos = Array();
			$blogs = new Blogs();
			foreach( $this->getBlogs() as $blogId ) {
				$blogInfos[] = $blogs->getBlogInfo( $blogId );
			}
			
			return( $blogInfos );
		}
		
		function setMode( $mode )
		{
			$this->_mode = $mode;
		}
		
		function getMode()
		{
			return( $this->_mode );
		}
	}
?>