<?php

	/**
	 * Your custom block locations should extend this class, as it provides the interface that the plugin
	 * is expecting.
	 * 
	 * The CustomBlockProcessor::process( $block, $blog ) method is meant to hold the processing logic of your class. 
	 * You can in there implement your own processing logic, in case the pre-defined options of "top" and "bottom" 
	 * do not satisfy you. While implementing custom block locations requires some development skills, it usually
	 * won't require more than implementing a regular expression to place your content in the right place in the page. 
	 */
	class CustomBlock
	{
		/**
		 * @param content The content that is currently being processed
		 * @param block An AdBlock object, which is the block currently being processed. 
		 * @param blog A BlogInfo object, with information regarding the current blog
		 * @param eventInfo An associative array containing information about the event. $eventInfo['from'] contains
		 * the name of the class that launched the event while $eventInfo['tempate'] contains the name
		 * of the template being currently processed.
		 * @return This class is expected to return the modified content, after applying our custom
		 * modifications to it.
		 * @static
		 */
		function process( $content, $block, $blog, $eventInfo )
		{
			return( $content );
		}
	}
?>