<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/arrayvalidator.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/emptyvalidator.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/ads/class/view/adminadblockslistview.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/ads/class/dao/adblocks.class.php" );	

    /**
	 * Deletes one or more adblocks
     */
    class AdminDeleteAdBlocksAction extends AdminAction 
	{

    	var $_blockId;
        var $_blockIds;

    	/**
         * Constructor. If nothing else, it also has to call the constructor of the parent
         * class, BlogAction with the same parameters
         */
        function AdminDeleteAdBlocksAction( $actionInfo, $request )
        {
        	$this->AdminAction( $actionInfo, $request );
			
			$this->_mode = $actionInfo->getActionParamValue();
        	// get the array that contains the categories we'd like to delete
			if( $this->_mode == "deleteAdBlock" ) 
				$this->registerFieldValidator( "blockId", new IntegerValidator());
			else 
				$this->registerFieldValidator( "blockIds", new ArrayValidator());
				
			$view = new AdminAdBlocksListView( $this->_blogInfo );
			$view->setErrorMessage( $this->_locale->tr("error_incorrect_adblock_id"));
			$this->setValidationErrorView( $view );	
			
			$this->requireAdminPermission( "manage_ad_blocks" );	
        }

		/**
		 * @private
		 */
		function _deleteAdBlocks()
		{
			$blocks = new AdBlocks();
			
			$errorMessage = "";
			$successMessage = "";
			$totalOk = 0;
			
            foreach( $this->_blockIds as $blockId ) {

            	// get the block
                $block = $blocks->getAdBlock( $blockId );
				if( $block ) {

					// if everything correct, we can proceed and delete it
					if( !$blocks->deleteAdBlock( $blockId ))
						$errorMessage .= $this->_locale->pr("error_deleting_adblock")."<br/>";
					else {
						if( $totalOk < 2 )
							$successMessage .= $this->_locale->pr("adblock_deleted_ok", $block->getName())."<br/>";
						else
							$successMessage = $this->_locale->pr( "adblocks_deleted_ok", $totalOk );
					}
				}
				else {
					$errorMessage .= $this->_locale->pr("error_deleting_adblock2", $blockId)."<br/>";
				}
        	}
			
			// prepare the view and all the information it needs to know
			$this->_view = new AdminAdBlocksListView( $this->_blogInfo );
			if( $errorMessage != "" ) 
				$this->_view->setErrorMessage( $errorMessage );
			if( $successMessage != "" ) {
				// and clear the cache to avoid outdated information
				$this->_view->setSuccessMessage( $successMessage );
			}
				
			$this->setCommonData();
			
			return true;
		}

        /**
         * Carries out the specified action
         */
        function perform()
        {
			// prepare the parameters.. If there's only one category id, then add it to
			// an array.
			if( $this->_mode == "deleteAdBlock" ) {
				$this->blockIds = Array();
				$this->_blockIds[] = $this->_request->getValue( "blockId" );
			}
			else
				$this->_blockIds = $this->_request->getValue( "blockIds" );
			
            return $this->_deleteAdBlocks();
        }
    }
?>
