<?php

	lt_include( PLOG_CLASS_PATH."class/action/admin/adminaction.class.php" );
	lt_include( PLOG_CLASS_PATH."class/view/admin/adminplugintemplatedview.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/ads/class/view/adminadblockslistview.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/stringvalidator.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/integervalidator.class.php" );
	lt_include( PLOG_CLASS_PATH."class/data/validator/arrayvalidator.class.php" );	
	lt_include( PLOG_CLASS_PATH."plugins/ads/class/dao/adblock.class.php" );
	lt_include( PLOG_CLASS_PATH."plugins/ads/class/dao/adblocks.class.php" );
	
	class AdminAddAdBlockAction extends AdminAction
	{
		function AdminAddAdBlockAction( $actionInfo, $request )
		{
			$this->AdminAction( $actionInfo, $request );			
			$this->requireAdminPermission( "manage_ad_blocks" );
			
			$this->registerFieldValidator( "adBlockName", new StringValidator());
			$this->registerFieldValidator( "adBlockMode", new IntegerValidator());
			$this->registerFieldValidator( "adBlockPosition", new IntegerValidator());			
			$this->registerFieldValidator( "adBlogsList", new ArrayValidator(), true );
			$view = new AdminPluginTemplatedView( $this->_blogInfo, "ads",  "newadblock" );
			$view->setErrorMessage( $this->_locale->tr("error_adding_adblock" ));
			$this->setValidationErrorView( $view );
		}
		
		function perform()
		{
			$block = new AdBlock();
			$block->setName( $this->_request->getValue( "adBlockName" ));
			$mode = $this->_request->getValue( "adBlockMode" );
			$block->setMode( $mode );
			$block->setPosition( $this->_request->getValue( "adBlockPosition" ));
			$block->setCode( $this->_request->getValue( "adBlockCode" ));
			
			$mode = $this->_request->getValue( "adBlockMode" );
			if( $mode == PLUGIN_ADS_BLOGS_INCLUDE_LIST || $mode == PLUGIN_ADS_BLOGS_EXCLUDE_LIST ) {
				$block->setBlogs( $this->_request->getValue( "adBlogsList" ));
			}
			
			$blocks = new AdBlocks();
			if( !$blocks->addAdBlock( $block )) {
				$this->_view = new AdminPluginTemplatedView( $this->_blogInfo, "ads",  "newadblock" );
				$this->_view->setErrorMessage( $this->_locale->tr("error_adding_adblock" ));
				$this->setCommonData( true );
				return( false );
			}
			
			$this->_view = new AdminAdBlocksListView( $this->_blogInfo );
			$this->setCommonData();
			
			return( true );
		}
	}
?>