/*
 * Decompiled with CFR 0.152.
 */
package nts.node;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import nts.base.Dimen;
import nts.base.Glue;
import nts.io.CntxLog;
import nts.io.Log;
import nts.node.Box;
import nts.node.InsertNode;
import nts.node.Insertion;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;
import nts.node.VBoxNode;
import nts.node.VertSplit;

public abstract class PageSplit
extends VertSplit {
    private boolean discarding;
    private boolean nullSpecs;
    private Node last;
    private Map insMap;
    private NodeList maybeOver;
    public int insertPenalties;
    private Dimen bestGoal;
    private NodeList heldOver;

    private void restart() {
        this.discarding = true;
        this.nullSpecs = true;
        this.last = null;
        this.insMap.clear();
        this.maybeOver.clear();
    }

    protected void freezeSpecs() {
        if (this.nullSpecs) {
            this.initSpecs();
            this.nullSpecs = false;
        }
    }

    protected abstract void initSpecs();

    public Node lastSpecialNode() {
        Node node = this.lastNode();
        return node != null ? node : this.last;
    }

    public boolean canChangeDimens() {
        return !this.nullSpecs;
    }

    protected boolean waitingForMore() {
        return true;
    }

    protected void passWhilePrunning(Node node) {
        this.pass(node);
    }

    protected void passWhileBreaking(Node node) {
        this.pass(node);
    }

    protected int extraPenalty() {
        return this.insertPenalties;
    }

    protected abstract void setInsVBox(int var1, Box var2);

    protected abstract Box getInsVBox(int var1);

    protected abstract Glue getInsSkip(int var1);

    protected abstract Dimen getInsSize(int var1);

    protected abstract int getInsFactor(int var1);

    protected abstract void traceSplitCost(int var1, Dimen var2, Dimen var3, int var4);

    protected abstract Node splitTopAdjustment(Dimen var1, Glue var2);

    private void pass(Node node) {
        Node node2 = this.last = node.discardable() ? node : null;
        if (node.isInsertion()) {
            this.freezeSpecs();
            Insertion ins = node.getInsertion();
            Integer key = new Integer(ins.num);
            InsRecord rec = (InsRecord)this.insMap.get(key);
            if (rec == null) {
                PageSplit pageSplit = this;
                if (pageSplit == null) {
                    throw null;
                }
                rec = pageSplit.new InsRecord(ins.num);
                this.insMap.put(key, rec);
            }
            if (rec.isFull()) {
                this.maybeOver.append(node);
                this.insertPenalties += ins.floatCost.intVal();
            } else {
                rec.record(ins);
            }
        }
    }

    protected void markBestPlace() {
        Iterator iterator = this.insMap.values().iterator();
        while (iterator.hasNext()) {
            ((InsRecord)iterator.next()).markBest();
        }
        this.heldOver.append(this.maybeOver);
        this.maybeOver.clear();
        this.bestGoal = this.goal;
    }

    private boolean step() {
        if (this.discarding) {
            boolean pruned = this.pruneTop();
            if (!this.nullSpecs) {
                this.adjustDepth();
            }
            if (pruned) {
                this.freezeSpecs();
                this.discarding = false;
            } else {
                return false;
            }
        }
        return this.findBreak();
    }

    public void build() {
        while (this.step()) {
            NodeList list = this.split();
            if (this.insertsWanted()) {
                Iterator iterator = this.insMap.values().iterator();
                while (iterator.hasNext()) {
                    ((InsRecord)iterator.next()).finish();
                }
                this.insertPenalties = this.heldOver.length();
                list = this.withoutInserts(list);
            } else {
                this.insertPenalties = 0;
                this.heldOver.clear();
            }
            this.restart();
            if (!this.performOutput(list, this.bestGoal)) continue;
            return;
        }
    }

    protected abstract boolean insertsWanted();

    protected abstract boolean performOutput(NodeList var1, Dimen var2);

    private NodeList withoutInserts(NodeList list) {
        NodeList result = new NodeList();
        NodeEnum nodes = list.nodes();
        while (nodes.hasMoreNodes()) {
            Node node = nodes.nextNode();
            if (node.isInsertion()) continue;
            result.append(node);
        }
        return result;
    }

    public void startNextPage(NodeEnum output) {
        this.setNullSpecs();
        NodeList contrib = new NodeList(this.data);
        this.data = new Vector();
        this.append(this.heldOver);
        this.heldOver.clear();
        this.append(output);
        this.append(contrib);
    }

    public void startNextPage() {
        this.startNextPage(NodeList.EMPTY_ENUM);
    }

    protected void show(Log log, int depth, int breadth, boolean act) {
        NodeEnum nodes;
        if (act) {
            nodes = this.heldOver.nodes();
            if (nodes.hasMoreNodes()) {
                log.startLine().add("### current page:").add(" (held over for next output)");
                CntxLog.addItems(log, nodes, depth, breadth);
            }
        } else {
            nodes = this.currPageList();
            if (nodes.hasMoreNodes()) {
                log.startLine().add("### current page:");
                CntxLog.addItems(log, nodes, depth, breadth);
                if (!this.nullSpecs) {
                    log.startLine().add("total height ").add(this.soFar.toString());
                    log.startLine().add(" goal height ").add(this.goal.toString());
                    Iterator iterator = this.insMap.values().iterator();
                    while (iterator.hasNext()) {
                        ((InsRecord)iterator.next()).show(log);
                    }
                }
            }
        }
        nodes = this.contribList();
        if (nodes.hasMoreNodes()) {
            log.startLine().add("### recent contributions:");
            CntxLog.addItems(log, nodes, depth, breadth);
        }
    }

    public abstract void show(Log var1, int var2, int var3);

    private final void block$() {
        this.insMap = new TreeMap();
        this.maybeOver = new NodeList();
        this.restart();
        this.insertPenalties = 0;
        this.heldOver = new NodeList();
    }

    public PageSplit() {
        this.block$();
    }

    private class InsRecord {
        private final int num;
        private Dimen size;
        private boolean full = false;
        private Vector data = new Vector();
        private int bestCount = 0;

        public boolean isFull() {
            return this.full;
        }

        public void markBest() {
            this.bestCount = this.data.size();
        }

        public void record(Insertion ins) {
            Dimen delta = PageSplit.this.goal.plus(PageSplit.this.soFar.getShrink()).minus(PageSplit.this.soFar.getNatural()).minus(PageSplit.this.depth);
            Dimen scal = this.insScale(ins.size, this.num);
            if (!(scal.moreThan(0) && scal.moreThan(delta) || this.size.plus(ins.size).moreThan(PageSplit.this.getInsSize(this.num)))) {
                this.size = this.size.plus(ins.size);
                PageSplit.this.goal = PageSplit.this.goal.minus(scal);
                this.data.add(ins.list);
            } else {
                this.split(ins);
            }
        }

        private void split(Insertion ins) {
            Dimen space;
            int fac = PageSplit.this.getInsFactor(this.num);
            if (fac <= 0) {
                Dimen dimen = Dimen.MAX_VALUE;
            } else {
                space = PageSplit.this.goal.minus(PageSplit.this.soFar.getNatural()).minus(PageSplit.this.depth);
                if (fac != 1000) {
                    space = space.over(fac).times(1000);
                }
            }
            space = space.min(PageSplit.this.getInsSize(this.num).minus(this.size));
            PageSplit pageSplit = PageSplit.this;
            if (pageSplit == null) {
                throw null;
            }
            InsertSplit splitter = pageSplit.new InsertSplit(ins.list.nodes(), ins.topSkip);
            NodeList head = splitter.makeSplitting(space, ins.maxDepth);
            Dimen bestSize = splitter.getBestSize();
            Node breakNode = splitter.breakNode();
            int cost = breakNode == null ? -10000 : (breakNode.isPenalty() ? breakNode.getPenalty().intVal() : 0);
            PageSplit.this.traceSplitCost(this.num, space, bestSize, cost);
            this.full = true;
            this.size = this.size.plus(bestSize);
            PageSplit.this.goal = PageSplit.this.goal.minus(this.insScale(bestSize, this.num));
            this.data.add(head);
            PageSplit.this.insertPenalties += cost;
            if (!splitter.isEmpty()) {
                splitter.pruneTop();
                NodeList tail = new NodeList(splitter.nodes());
                VBoxNode vbox = VBoxNode.packedOf(tail);
                PageSplit.this.maybeOver.append(new InsertNode(ins.makeCopy(tail, vbox.getHeight().plus(vbox.getDepth()))));
            }
        }

        public void finish() {
            if (!this.data.isEmpty()) {
                NodeList list = new NodeList();
                NodeEnum boxList = PageSplit.this.getInsVBox(this.num).getVertList();
                if (boxList != null) {
                    list.append(boxList);
                }
                int i = 0;
                while (i < this.bestCount) {
                    list.append((NodeList)this.data.get(i));
                    ++i;
                }
                PageSplit.this.setInsVBox(this.num, VBoxNode.packedOf(list));
            }
        }

        private Dimen insScale(Dimen size, int num) {
            int fac = PageSplit.this.getInsFactor(num);
            return fac == 1000 ? size : size.over(1000).times(fac);
        }

        public void show(Log log) {
            log.endLine().addEsc("insert").add(this.num).add(" adds ").add(this.size.over(1000).times(PageSplit.this.getInsFactor(this.num)).toString());
            if (this.full) {
                log.add(", #").add(this.data.size()).add(" might split");
            }
        }

        public InsRecord(int number) {
            this.num = number;
            Box box = PageSplit.this.getInsVBox(this.num);
            Glue skip = PageSplit.this.getInsSkip(this.num);
            this.size = box.getHeight().plus(box.getDepth());
            PageSplit.this.goal = PageSplit.this.goal.minus(this.insScale(this.size, this.num)).minus(skip.getDimen());
            PageSplit.this.soFar.add(skip.resizedCopy(Dimen.ZERO));
        }
    }

    protected class InsertSplit
    extends VertSplit {
        private final Glue topSkip;
        private Dimen bestSize;

        public Dimen getBestSize() {
            return this.bestSize;
        }

        protected void markBestPlace() {
            this.bestSize = this.soFar.getNatural().plus(this.depth);
        }

        protected Node topAdjustment(Dimen height) {
            return PageSplit.this.splitTopAdjustment(height, this.topSkip);
        }

        public InsertSplit(NodeEnum nodes, Glue topSkip) {
            super(nodes);
            this.topSkip = topSkip;
        }
    }
}

