/*
 * Decompiled with CFR 0.152.
 */
package nts.base;

import java.io.Serializable;
import nts.base.IntProvider;

public class Num
implements Serializable,
IntProvider {
    public static final Num NULL;
    public static final Num ZERO;
    public static final int MAX_INT_VALUE = Integer.MAX_VALUE;
    private static final RomanDigit[] romanDigits;
    private final int value;

    public static Num valueOf(int num) {
        return new Num(num);
    }

    public final int intVal() {
        return this.value;
    }

    public int sign() {
        return this.value > 0 ? 1 : (this.value < 0 ? -1 : 0);
    }

    public boolean equals(int i) {
        return this.value == i;
    }

    public boolean equals(Num n) {
        return this.value == n.intVal();
    }

    public boolean lessThan(int i) {
        return this.value < i;
    }

    public boolean lessThan(Num n) {
        return this.value < n.intVal();
    }

    public boolean moreThan(int i) {
        return this.value > i;
    }

    public boolean moreThan(Num n) {
        return this.value > n.intVal();
    }

    public Num negative() {
        return new Num(-this.value);
    }

    public Num plus(int i) {
        return new Num(this.value + i);
    }

    public Num plus(Num n) {
        return new Num(this.value + n.intVal());
    }

    public Num minus(int i) {
        return new Num(this.value - i);
    }

    public Num minus(Num n) {
        return new Num(this.value - n.intVal());
    }

    public Num times(int i) {
        return new Num(this.value * i);
    }

    public Num times(Num n) {
        return new Num(this.value * n.intVal());
    }

    public Num over(int i) {
        return new Num(this.value / i);
    }

    public Num over(Num n) {
        return new Num(this.value / n.intVal());
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public String toOctString() {
        return Integer.toOctalString(this.value);
    }

    public String toHexString() {
        return Integer.toHexString(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Num && ((Num)o).value == this.value;
    }

    public static String romanString(int n) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (true) {
            RomanDigit dig = romanDigits[i];
            while (n >= dig.value) {
                buf.append(dig.digit);
                n -= dig.value;
            }
            if (n <= 0) break;
            int j = i;
            while (!Num.romanDigits[++j].precedable) {
            }
            if (n + Num.romanDigits[j].value >= dig.value) {
                buf.append(Num.romanDigits[j].digit).append(dig.digit);
                n -= dig.value - Num.romanDigits[j].value;
            }
            ++i;
        }
        return buf.toString();
    }

    private Num(int num) {
        this.value = num;
    }

    static {
        ZERO = Num.valueOf(0);
        romanDigits = new RomanDigit[]{new RomanDigit('m', 1000, false), new RomanDigit('d', 500, false), new RomanDigit('c', 100, true), new RomanDigit('l', 50, false), new RomanDigit('x', 10, true), new RomanDigit('v', 5, false), new RomanDigit('i', 1, true)};
    }

    private static final class RomanDigit {
        char digit;
        int value;
        boolean precedable;

        RomanDigit(char d, int v, boolean p) {
            this.digit = d;
            this.value = v;
            this.precedable = p;
        }
    }

    public static interface Provider {
        public Num getNumValue();
    }
}

